package xyz.zhiwei.edition.dao.impl.rpc.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import xyz.zhiwei.article.api.ContributionApi;
import xyz.zhiwei.cognitivedesign.dao.impl.rpc.config.FeignProxyUtil;
import xyz.zhiwei.explorer.api.ExplorerApi;

/**
 * Feign代理创建配置
 */
@Configuration
public class RpcApiImplConfig  {

    // 注入Spring管理的FeignProxyUtil实例
    private final FeignProxyUtil feignProxyUtil;
    public RpcApiImplConfig(FeignProxyUtil feignProxyUtil) {
        this.feignProxyUtil = feignProxyUtil;
    }

    
    @Value("${micrsvcaddress.explorer}")
    private String explorerApiUrl;
    @Value("${micrsvcaddress.article}")
    private String articleApiUrl;
    
    
    @Bean
    public ExplorerApi explorerApi() {
        return feignProxyUtil.createProxy(ExplorerApi.class, explorerApiUrl);
    }
    @Bean
    public ContributionApi contributionApi() {
        return feignProxyUtil.createProxy(ContributionApi.class, articleApiUrl);
    }
    
}
