package xyz.zhiwei.edition.dao.impl.rpc;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import xyz.zhiwei.article.api.ContributionApi;
import xyz.zhiwei.article.api.support.Message;
import xyz.zhiwei.cognitivedesign.dao.impl.rpc.BaseRpcDaoImpl;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.edition.dao.impl.rpc.mapper.GenericMapper;
import xyz.zhiwei.edition.morphism.principle.article.model.Contribution;


@Repository
public class ContributionDaoImpl extends BaseRpcDaoImpl<Contribution> {

	@Autowired
	private ContributionApi contributionApi;
	

	/**
	 * fK查询
	 * @param qualifier
	 * @return
	 */
    List<Contribution> fk(PrincipleQualifier<Contribution> qualifier) {
        return fk(qualifier.getSimilar());
    }
    List<Contribution> fk(Contribution p) {
    	xyz.zhiwei.article.morphism.principle.article.model.Contribution condition=GenericMapper.INSTANCE.toPo(p);
		Message<List<xyz.zhiwei.article.morphism.principle.article.model.Contribution>> msg=contributionApi.queryFk(condition);
		if(null!=msg) {
			return GenericMapper.INSTANCE.toContributionPr(msg.getResult());
		}
		return new ArrayList<>();
    }
	


}