package xyz.zhiwei.edition.dao.impl.rdb.impl.po;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import xyz.zhiwei.edition.dao.impl.rdb.impl.GenericMapper;
import xyz.zhiwei.edition.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.edition.model.base.Connotation;
import xyz.zhiwei.edition.morphism.principle.edition.model.base.ConnotationDifference;




public class EditionPo extends Edition{

	private static final long serialVersionUID = 6523822172240449353L;

	private String connotation;

    private String connotationDifference;

    private String paragraph;

    public EditionPo() {}

    public EditionPo(Edition edition,ObjectMapper objectMapper) {
    	GenericMapper.INSTANCE.editionToPo(edition, this);
    	toDbPo(objectMapper);
    }
    
    
    
    public EditionPo toPrinciple(ObjectMapper objectMapper,Boolean clean) {
    	
		String connotationDifference=getConnotationDifference();
		if(null!=connotationDifference){
			List<ConnotationDifference> cl=toModel(connotationDifference, new TypeReference<List<ConnotationDifference>>(){},objectMapper);
    		setConnotationDifferenceList(cl);
    		if(clean){
        		setConnotationDifference(null);
    		}
		}
		

		String connotation=getConnotation();
		if(null!=connotation){
			List<Connotation> cm=toModel(connotation, new TypeReference<List<Connotation>>(){},objectMapper);
    		setConnotationList(cm);
    		if(clean){
    			setConnotation(null);
    		}
		}
		

		String paragraph=getParagraph();
		if(null!=paragraph){
			List<Paragraph> pl=toModel(paragraph, new TypeReference<List<Paragraph>>(){},objectMapper);
    		setParagraphList(pl);
    		if(clean){
    			setParagraph(null);
    		}
		}
        return this;
    }
    
    
    
    private void toDbPo(ObjectMapper objectMapper) {

    	setConnotationDifference(toString(objectMapper,getConnotationDifferenceList()));
    	
    	setConnotation(toString(objectMapper,getConnotationList()));
    	
    	setParagraph(toString(objectMapper,getParagraphList()));
    	
    }
    
    
    
    private String toString(ObjectMapper objectMapper,Object o) {
    	
    	String str=null;
		try {
			str = objectMapper.writeValueAsString(o);
		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	
    	return str;
    }
    
    
    

	private <U> List<U> toModel(String respStr,TypeReference<List<U>> typeReference,ObjectMapper objectMapper){
		List<U> list=new ArrayList<U>();
		if(StringUtils.isBlank(respStr)) {
			return list;
		}
		try {
			list=objectMapper.readValue(respStr,typeReference);
		} catch (JsonParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JsonMappingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return list;
	}
    
    
    
    
	public String getConnotation() {
		return connotation;
	}

	public void setConnotation(String connotation) {
		this.connotation = connotation;
	}

	public String getConnotationDifference() {
		return connotationDifference;
	}

	public void setConnotationDifference(String connotationDifference) {
		this.connotationDifference = connotationDifference;
	}

	public String getParagraph() {
		return paragraph;
	}

	public void setParagraph(String paragraph) {
		this.paragraph = paragraph;
	}




}