package xyz.zhiwei.edition.dao.impl.rdb;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.fasterxml.jackson.databind.ObjectMapper;

import jakarta.annotation.Resource;
import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImagery;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSourcePage;
import xyz.zhiwei.edition.dao.impl.rdb.impl.GenericMapper;
import xyz.zhiwei.edition.dao.impl.rdb.impl.po.EditionPo;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;


@Repository
public class EditionDaoImpl implements Dao<Edition> {


	@Resource 
	private Dao<EditionPo> editionPoDao;

    @Autowired
	protected ObjectMapper objectMapper;
	
    
    
    
    
	@Override
	public List<Edition> subCollection(PrincipleQualifier<Edition> qualifier) {
		PrincipleQualifier<EditionPo> poQualifier=new PrincipleQualifier<>(EditionPo.class);
		GenericMapper.INSTANCE.editionToPoQualifier(qualifier, poQualifier);
		
		List<EditionPo> poList=editionPoDao.subCollection(poQualifier);
        List<Edition> pl=poList.stream().map(po -> po.toPrinciple(objectMapper, false)).collect(Collectors.toList());
        
		if(poList instanceof PrincipleSourcePage) {
			PrincipleSourcePage<EditionPo> pagePo=(PrincipleSourcePage<EditionPo>) poList;
			PrincipleSourcePage<Edition> page=new PrincipleSourcePage<Edition>(pl, pagePo.getTotal());
			return page;
		}
		return pl;
	}

	
	
	@Override
	public Long add(List<Edition> list) {
		List<EditionPo> poList=list.stream().map(pr -> new EditionPo(pr,objectMapper)).collect(Collectors.toList());
		PrincipleImagery<EditionPo> principleImagery=getPrincipleImagery(poList,list);
		return editionPoDao.add(principleImagery);
	}

	@Override
	public Long update(List<Edition> list) {
		List<EditionPo> poList=list.stream().map(pr -> new EditionPo(pr,objectMapper)).collect(Collectors.toList());
		PrincipleImagery<EditionPo> principleImagery=getPrincipleImagery(poList,list);
		return editionPoDao.update(principleImagery);
	}

	@Override
	public Long delete(List<Edition> list) {
		List<EditionPo> poList=list.stream().map(pr -> new EditionPo(pr,objectMapper)).collect(Collectors.toList());
		PrincipleImagery<EditionPo> principleImagery=getPrincipleImagery(poList,list);
		return editionPoDao.delete(principleImagery);
	}

	
	
	

	/**
	 * 把描述符透传到下一级
	 * @param list
	 * @return
	 */
	private PrincipleImagery<EditionPo> getPrincipleImagery(List<EditionPo> poList,List<Edition> list){
    	String describe=null;
        if (list instanceof PrincipleImagery<?>) {
        	describe=((PrincipleImagery<?>)list).getDescribe();
        }
    	return new PrincipleImagery<EditionPo>(poList,describe);
	}
}
