package xyz.zhiwei.article.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.article.api.model.EditionReviewInit;
import xyz.zhiwei.article.api.support.Message;
import xyz.zhiwei.article.morphism.appearance.hierarchy.accept.HierarchyAcceptAppearance;
import xyz.zhiwei.article.morphism.appearance.hierarchy.refuse.HierarchyRefuseAppearance;
import xyz.zhiwei.article.morphism.appearance.hierarchy.request.HierarchyRequestAppearance;
import xyz.zhiwei.article.morphism.appearance.hierarchy.request.HierarchyRequestInit;
import xyz.zhiwei.article.morphism.support.exception.BusinessException;
import xyz.zhiwei.article.web.support.RequestConstant;
import xyz.zhiwei.cognitivedesign.service.MorphismResponse;
import xyz.zhiwei.cognitivedesign.service.Service;

@RestController
@RequestMapping({"/hierarchy"})
public class HierarchyController {
    @Autowired
    private Service service;

	@Autowired
	protected HttpServletRequest request;

    /*
     * ========================查询=======================
     */


	/**
	 * 新增概念版本
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "updateForConcept.do", method = RequestMethod.POST)
	public Message<Long> updateForConcept(HttpServletRequest request,@RequestBody HierarchyRequestInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		HierarchyRequestAppearance init=new HierarchyRequestAppearance(token,initial);
		MorphismResponse<HierarchyRequestAppearance> resp=service.process(init);
		if(null==resp.getAdditionResponse(1)) {
			return Message.failure(-1L);
		}
		
		if(resp.getAdditionResponse(1).compareTo(0L)>0 ) {
			return Message.success(resp.getAdditionResponse(1));
		}else {
			return Message.failure(resp.getAdditionResponse(1));
		}
		
	}
	
	

	/**
	 * 审核更新
	 * @author zhanghaiting
	 * @parameter
	 * @return
	 */
	@RequestMapping(value = "updateCheck.do", method = RequestMethod.POST)
	public Message<Long> updateCheck(HttpServletRequest request,@RequestBody EditionReviewInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		if(initial.isAccept()) {
			try {
				HierarchyAcceptAppearance init=new HierarchyAcceptAppearance(token,initial.editionAcceptInit());
				MorphismResponse<HierarchyAcceptAppearance> resp=service.process(init);
				
				if(null==resp.getAdditionResponse(2)) {
					return Message.failure(-1L);
				}
				if(resp.getAdditionResponse(2).compareTo(0L)>0 ) {
					return Message.success(resp.getAdditionResponse(2));
				}else {
					return Message.failure(resp.getAdditionResponse(2));
				}
				
			}catch (BusinessException e) {
				return Message.failure(e.getErrorCode(),e.getMessage(),null);
			}
		}else {
			HierarchyRefuseAppearance init=new HierarchyRefuseAppearance(token,initial.editionRefuseInit());
			MorphismResponse<HierarchyRefuseAppearance> resp=service.process(init);
			return Message.success(resp.getModificationResponse(0));
		}
	}
	
}
