package xyz.zhiwei.article.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.article.api.support.Message;
import xyz.zhiwei.article.morphism.appearance.discussion.approve.DiscussionApproveAppearance;
import xyz.zhiwei.article.morphism.appearance.discussion.approve.DiscussionApproveInit;
import xyz.zhiwei.article.morphism.appearance.discussion.request.DiscussionRequestAppearance;
import xyz.zhiwei.article.morphism.appearance.discussion.request.DiscussionRequestInit;
import xyz.zhiwei.article.morphism.appearance.discussion.viewpage.DiscussionExplorerPage;
import xyz.zhiwei.article.morphism.appearance.discussion.viewpage.DiscussionViewPageAppearance;
import xyz.zhiwei.article.morphism.appearance.discussion.viewpage.DiscussionViewPageInit;
import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.support.facet.PageCondition;
import xyz.zhiwei.article.web.support.RequestConstant;
import xyz.zhiwei.cognitivedesign.service.MorphismResponse;
import xyz.zhiwei.cognitivedesign.service.Service;

@RestController
@RequestMapping({"/discussion"})
public class DiscussionController {
    @Autowired
    private Service service;

	@Autowired
	protected HttpServletRequest request;


	/**
	 * 分页查询讨论列表
	 * 
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryinpage.do", method = RequestMethod.POST)
	public Message<DiscussionExplorerPage> queryPage(@RequestBody PageCondition<DiscussionViewPageInit> condition) {

		DiscussionViewPageAppearance init=new DiscussionViewPageAppearance(condition);
		DiscussionViewPageAppearance pre=service.view(init);
		
		return Message.success(pre.getPage());
	}
	

	/**
	 * 新增
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "addforkey.do", method = RequestMethod.POST)
	public Message<Discussion> addforkey(@RequestBody DiscussionRequestInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		DiscussionRequestAppearance init=new DiscussionRequestAppearance(token,initial);
		MorphismResponse<DiscussionRequestAppearance> resp=service.process(init);
		
		return Message.success(resp.getA().getNewDiscussion());
	}
	
	
	/**
	 * 更新
	 * @author zhanghaiting
	 * @parameter
	 * @return
	 */
	@RequestMapping(value = "update.do", method = RequestMethod.POST)
	public Message<Long> update(@RequestBody DiscussionApproveInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		DiscussionApproveAppearance init=new DiscussionApproveAppearance(token,initial);
		MorphismResponse<DiscussionApproveAppearance> resp=service.process(init);
		
		return Message.success(resp.getModificationResponse(0));
	}
	
	
}
