package xyz.zhiwei.article.web;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.article.api.ContributionApi;
import xyz.zhiwei.article.api.model.ConceptContributionViewCondition;
import xyz.zhiwei.article.api.model.ExplorerContributionCondition;
import xyz.zhiwei.article.api.support.Message;
import xyz.zhiwei.article.morphism.appearance.contribution.viewall.ContributionViewAllAppearance;
import xyz.zhiwei.article.morphism.appearance.contribution.viewone.ContributionViewOneAppearance;
import xyz.zhiwei.article.morphism.appearance.contribution.viewtwo.ContributionViewTwoAppearance;
import xyz.zhiwei.article.morphism.appearance.explorer.viewpublic.ContributorViewPublicAppearance;
import xyz.zhiwei.article.morphism.appearance.explorer.viewreview.ContributorReViewInit;
import xyz.zhiwei.article.morphism.appearance.explorer.viewreview.ContributorViewReviewAppearance;
import xyz.zhiwei.article.morphism.appearance.explorer.viewsingle.ContributorSingleInit;
import xyz.zhiwei.article.morphism.appearance.explorer.viewsingle.ContributorViewSingleAppearance;
import xyz.zhiwei.article.morphism.facet.contribution.ConceptContributionViewFacet;
import xyz.zhiwei.article.morphism.facet.contribution.ConceptContributionViewInit;
import xyz.zhiwei.article.morphism.facet.contribution.ContributionExplorerFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.support.facet.Page;
import xyz.zhiwei.article.morphism.support.facet.PageCondition;
import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.service.Service;

@RestController
@RequestMapping({"/contribution"})
public class ContributionController implements ContributionApi{
	@Autowired
	protected HttpServletRequest request;

    @Autowired
    private Service service;

    @Autowired
    private Dao<Contribution> contributionDaoImpl;
    
    /*
     * ========================查询=======================
     */

	/**
	 * 外键查询
	 * @param condition
	 * @return
	 */
	@RequestMapping(value = "queryFk.do", method = RequestMethod.POST)
	@Override
	public Message<List<Contribution>> queryFk(@RequestBody Contribution condition) {
		PrincipleQualifier<Contribution> pq=ContributionQualify.PQ.fk(condition);
		List<Contribution> list=contributionDaoImpl.subCollection(pq);
		return Message.success(list);
	}
	
	
	/**
	 * 查询概念贡献空间
	 * @param t{ conceptId,explorerId,deep}
	 * @return
	 */
	@RequestMapping(value = "querySpace.do", method = RequestMethod.POST)
	public Message<ConceptContributionViewFacet> querySpace(@RequestBody ConceptContributionViewCondition condition) {
		
		ConceptContributionViewInit conditionInit=condition.getInit();
		
		if(0==condition.getDeep()){
			ContributionViewAllAppearance init=new ContributionViewAllAppearance(conditionInit);
			ContributionViewAllAppearance pre=service.view(init);
			return Message.success(pre.getConceptContributionViewFacet());
		}else if(1==condition.getDeep()){
			ContributionViewOneAppearance init=new ContributionViewOneAppearance(conditionInit);
			ContributionViewOneAppearance pre=service.view(init);
			return Message.success(pre.getConceptContributionViewFacet());
		}else if(2==condition.getDeep()){
			ContributionViewTwoAppearance init=new ContributionViewTwoAppearance(conditionInit);
			ContributionViewTwoAppearance pre=service.view(init);
			return Message.success(pre.getConceptContributionViewFacet());
		}
		
		return Message.failure(null);
	}

	/**
	 * 分页查询贡献者列表
	 * 
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryinpage.do", method = RequestMethod.POST)
	public Message<Page<ContributionExplorerFacet>> queryPage(@RequestBody PageCondition<ExplorerContributionCondition> pageCondition) {
		ExplorerContributionCondition condition=pageCondition.getSimilar();
		
		if(null==condition.getExplorerId()||0==condition.getExplorerId()) {
			//评审视角
			if(1==condition.getStateActive()){
				PageCondition<ContributorReViewInit> initCondition=pageCondition.change(ExplorerContributionCondition::getContributorReViewInit);
				ContributorViewReviewAppearance init=new ContributorViewReviewAppearance(initCondition);
				ContributorViewReviewAppearance pre=service.view(init);
				return Message.success(pre.getPage());
			//公共视角
			}else{
				PageCondition<Long> initPageConceptId=pageCondition.change(ExplorerContributionCondition::getConceptId);
				ContributorViewPublicAppearance init=new ContributorViewPublicAppearance(initPageConceptId);
				ContributorViewPublicAppearance pre=service.view(init);
				Page<ContributionExplorerFacet> page=pre.getPage();
				return Message.success(page);
			}
			
		//用户涉足的领域
		}else {
			PageCondition<ContributorSingleInit> initCondition=pageCondition.change(ExplorerContributionCondition::getContributorSingleInit);
			ContributorViewSingleAppearance init=new ContributorViewSingleAppearance(initCondition);
			ContributorViewSingleAppearance pre=service.view(init);
			return Message.success(pre.getPage());
		}
	}

	
	
}
