package xyz.zhiwei.article.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.article.api.model.ConceptViewCondition;
import xyz.zhiwei.article.api.support.Message;
import xyz.zhiwei.article.morphism.appearance.concept.viewall.ConceptViewAllAppearance;
import xyz.zhiwei.article.morphism.appearance.concept.viewone.ConceptViewOneAppearance;
import xyz.zhiwei.article.morphism.appearance.concept.viewtwo.ConceptViewTwoAppearance;
import xyz.zhiwei.article.morphism.facet.concept.ConceptHierarchyFacet;
import xyz.zhiwei.article.morphism.facet.concept.ConceptViewInit;
import xyz.zhiwei.cognitivedesign.service.Service;

@RestController
@RequestMapping({"/concept"})
public class ConceptController {
    @Autowired
    private Service service;

	@Autowired
	protected HttpServletRequest request;

    /*
     * ========================查询=======================
     */


	@RequestMapping(value = "querySpace.do", method = RequestMethod.POST)
	public Message<ConceptHierarchyFacet> querySpace(@RequestBody ConceptViewCondition condition) {
		ConceptViewInit conceptViewInit=new ConceptViewInit(condition.getId());
		
		if(0==condition.getDeep()){
			ConceptViewAllAppearance init=new ConceptViewAllAppearance(conceptViewInit);
			ConceptViewAllAppearance pre=service.view(init);
			return Message.success(pre.getConceptHierarchyFacet());
		}else if(1==condition.getDeep()){
			ConceptViewOneAppearance init=new ConceptViewOneAppearance(conceptViewInit);
			ConceptViewOneAppearance pre=service.view(init);
			return Message.success(pre.getConceptHierarchyFacet());
		}else if(2==condition.getDeep()){
			ConceptViewTwoAppearance init=new ConceptViewTwoAppearance(conceptViewInit);
			ConceptViewTwoAppearance pre=service.view(init);
			return Message.success(pre.getConceptHierarchyFacet());
		}
		
		return Message.failure(null);
	}

	
	
	
	
	
	
}
