package xyz.zhiwei.article.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.article.api.support.Message;
import xyz.zhiwei.article.morphism.appearance.article.request.ArticleRequestAppearance;
import xyz.zhiwei.article.morphism.appearance.article.request.ArticleRequestInit;
import xyz.zhiwei.article.morphism.appearance.article.view.ArticleFacet;
import xyz.zhiwei.article.morphism.appearance.article.view.ArticleViewAppearance;
import xyz.zhiwei.article.web.support.RequestConstant;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.service.MorphismResponse;
import xyz.zhiwei.cognitivedesign.service.Service;

@RestController
@RequestMapping({"/article"})
public class ArticleController {
    @Autowired
    private Service service;

	@Autowired
	protected HttpServletRequest request;

    /*
     * ========================查询=======================
     */
	/**
	 * 文章详情
	 * @param p
	 * @return
	 */
	@RequestMapping(value = "queryone.do", method = RequestMethod.POST)
	public Message<ArticleFacet> queryOne(@RequestBody Principle<Long> condition) {
		
		ArticleViewAppearance init=new ArticleViewAppearance(condition.getId());
		ArticleViewAppearance pre=service.view(init);
		
		return Message.success(pre.getArticleFacet());
	}
	


	

	/**
	 * 新增文章版本
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "updateForArticle.do", method = RequestMethod.POST)
	public Message<Long> updateForArticle(HttpServletRequest request,@RequestBody ArticleRequestInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		ArticleRequestAppearance init=new ArticleRequestAppearance(token,initial);
		MorphismResponse<ArticleRequestAppearance> resp=service.process(init);
		
		return Message.success(resp.getAdditionResponse(1));
	
	}
}
