package xyz.zhiwei.article.morphism.support.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import xyz.zhiwei.cognitivedesign.morphism.Principle;


/**
* @author zhanghaiting
*/

public class ListMapper {

	/**
	 * 索引
	 * @param list
	 * @return
	 */
    @SuppressWarnings("unchecked")
	public static <ID,T> Map<ID,T> getMapOfList(List<? extends Principle<ID>> list) {

        Map<ID, T> map = new HashMap<>();

        if(null!=list){
            for (int i = 0; i < list.size(); i++) {
            	ID id=list.get(i).getId();
            	if(null!=id){
                    map.put(id, (T) list.get(i));
            	}
            }
        }
        
        return map;
    }
    
    public static <ID,T> Map<ID,T> getMapOfList(List<T> list,Function<T,ID> idFun) {
        Map<ID, T> map = new HashMap<>();

        if(null!=list){
            for (int i = 0; i < list.size(); i++) {
            	T t=list.get(i);
            	ID id=idFun.apply(t);
            	if(null!=id){
                    map.put(id, t);
            	}
            }
        }
        return map;
    }
    


    public static <T extends Principle<Integer>> List<T> orderListByMethodReturn(List<T> orgList,
                                                      String compareFieldMethod, String orderType) {
		
//    	orgList=orgList.stream()
//    			.sorted(Comparator.comparing(BaseModel::getId))
//    			.collect(Collectors.toList());
		
    	
    	orgList=orgList.stream()
    			.sorted(Comparator.comparing(Principle::getId))
    			.collect(Collectors.toList());
    	
    	
    	
    	return orgList;
	}
    
    
    
}
































