package xyz.zhiwei.article.morphism.support.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * 层级函数
 */
public class HierarchyMapper {


	

	/**
	 * 为层级构建指针索引
	 * @author zhanghaiting
	 * @date 2020年2月26日
	 * 
	 * @param topConceptModel
	 * tIdFun:concep.getId()
	 * tListFun: concep.getInferiorList();
	 * @return
	 */
	public static <T> Map<Long,T> getTMapFormTopT(T t,Function<T,Long> tIdFun,Function<T,List<T>> tListFun){

		Map<Long,T> allInferiorMap=new HashMap<Long,T>();
		//当前要填充的概念列表
		List<T> conceptListNow;
		//下次要填充的概念列表
		List<T> conceptListNext;
		

		//===========列表初始化===========
		conceptListNow=new ArrayList<>();
		conceptListNow.add(t);
		conceptListNext=new ArrayList<>();
		

		//===========递归操作准入条件===========
		while(conceptListNow.size()>0){
			//单元操作
			for (int i = 0; i < conceptListNow.size(); i++) {
				T concepOneNow=conceptListNow.get(i);
				allInferiorMap.put(tIdFun.apply(concepOneNow), concepOneNow);
				List<T> inferiorConceptOneNow=tListFun.apply(concepOneNow);
				if(null==inferiorConceptOneNow||inferiorConceptOneNow.size()==0) {
					continue;
				}else {
					conceptListNext.addAll(inferiorConceptOneNow);
				}
			}
			//重置列表数据
			conceptListNow=conceptListNext;
			conceptListNext=new ArrayList<>();
		}
		return allInferiorMap;
	}
	
	
	

	/**
	 * 层级关系 填充数据
	 * @param <T>
	 * @param <D>
	 * @param tMap
	 * @param dataList
	 * @param dIdFun
	 * @param tSetDFun
	 */
	public static <T,D> void updateTData(
			Map<Long,T> tMap,List<D> dataList,
			Function<D,Long> dIdFun,BiConsumer<T,D> tSetDFun) {
		//填充数据
		for (int i = 0; i < dataList.size(); i++) {
			D d=dataList.get(i);
			Long id=dIdFun.apply(d);
			T t=tMap.get(id);
			if(null!=t) {
				tSetDFun.accept(t, d);
			}
		}
	}
	
}
