package xyz.zhiwei.article.morphism.support.facet;

import java.util.function.Function;

public class PageCondition<P> {

	private P similar;
	private Integer pageNum;
	private Integer pageSize;
	
	
	public PageCondition() {}
	
	public PageCondition(P similar,Integer pageNum,Integer pageSize) {
		this.similar=similar;
		this.pageNum=pageNum;
		this.pageSize=pageSize;
	}
	
	public <T> PageCondition<T> change(Function<P,T> getFun) {
		T t=getFun.apply(this.similar);
		return new PageCondition<>(t,this.pageNum,this.pageSize);
	}
	
	
	public P getSimilar() {
		return similar;
	}
	public void setSimilar(P similar) {
		this.similar = similar;
	}
	public Integer getPageNum() {
		return pageNum;
	}
	public void setPageNum(Integer pageNum) {
		this.pageNum = pageNum;
	}
	public Integer getPageSize() {
		return pageSize;
	}
	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}
	


}
