package xyz.zhiwei.article.morphism.support.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 连接两个列表，生成新列表
 * @param <Composite>
 */
public class LinkTwoListFacet<Composite> extends ArrayList<Composite>{

	private static final long serialVersionUID = 1L;

	
	/**
	 * 
	 * @param <Main> 主类型
	 * @param <Attribute> 属性元素
	 * @param <ID> 标识类型 (Long/String)
	 * @param mainList 主列表(班级)
	 * @param attributeList 属性列表(班主任列表)
	 * @param attributeIdFun 主类型提供的属性ID(班级中的班主任ID)
	 * @param idFun 属性标识键(班主任ID)
	 * @param newCompositeFromMainAndAttribute 生成的复合对象(班级含班主任)
	 */
	public <Main,Attribute,ID> LinkTwoListFacet(
    		List<Main> mainList,
    		List<Attribute> attributeList,
    		Function<Main,ID> attributeIdFun,
    		Function<Attribute,ID> idFun,
    		BiFunction<Main,Attribute,Composite> newCompositeFromMainAndAttribute) {
		

    	//子列表索引
    	Map<ID,Attribute> attributeMap=attributeList.stream().collect(Collectors.toMap(attribute->idFun.apply(attribute),Function.identity()));
    	
    	//连接两列表
    	for (Main main : mainList) {
    		ID attributeId=attributeIdFun.apply(main);
    		Attribute attribute=attributeMap.get(attributeId);
			if(null!=attribute) {
				//生成复合模型
				Composite composite=newCompositeFromMainAndAttribute.apply(main, attribute);
				this.add(composite);
			}
		}
		
	}
}
