package xyz.zhiwei.article.morphism.support.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * 列表分为新增和更新
 */
public class AddAndUpdateGroupFacet<T> {
	
	private List<T> addition;
	private List<T> modification;
	
	
	
	/**
	 * 把list区分为添加和更新
	 * @param <ID>
	 * @param list 要区分的列表
	 * @param existList 已存在的列表
	 * @param keyFun 对象的唯一标识键（用于判断是否为同一对象）
	 * @param idFun 获取对象的id（用于从已存在对象中获取ID）
	 * @param setIdFun 给对象设置id（用于给新增对象设置已存在对象的ID）
	 */
	public <ID> AddAndUpdateGroupFacet(List<T> list, List<T> existList,
			Function<T, String> keyFun, Function<T, ID> idFun, BiConsumer<T, ID> setIdFun) {
		
		// 初始化新增和更新列表
		this.addition = new ArrayList<>();
		this.modification = new ArrayList<>();
		
		// 空值处理
		if (list == null || list.isEmpty()) {
			return;
		}
		if (existList == null) {
			existList = new ArrayList<>();
		}
		
		// 将已存在列表按唯一标识分组，便于快速查找
		Map<String, T> existMap = new HashMap<>();
		for (T exist : existList) {
			String key = keyFun.apply(exist);
			if(null!=key) {
				existMap.put(key, exist);
			}
		}
		
		// 遍历待处理列表，区分新增和更新
		for (T item : list) {
			String key = keyFun.apply(item);
			if (null!=key && existMap.containsKey(key)) {
				// 存在相同标识的对象，属于更新
				T existItem = existMap.get(key);
				// 如果需要，将已存在对象的ID设置到待处理对象中（通常更新时需要保持ID一致）
				ID existId = idFun.apply(existItem);
				setIdFun.accept(item, existId);
				modification.add(item);
			} else {
				// 不存在相同标识的对象，属于新增
				addition.add(item);
			}
		}
	}
	
	
	
	public List<T> getAddition() {
		return addition;
	}
	public void setAddition(List<T> addition) {
		this.addition = addition;
	}
	public List<T> getModification() {
		return modification;
	}
	public void setModification(List<T> modification) {
		this.modification = modification;
	}
	
}
