package xyz.zhiwei.article.morphism.support.constant;

/**
 * 事件类型枚举类
 * 定义系统中涉及的事件类型，使用Long类型标识
 */
public enum EventEnum {

    /**
     * 层级相关事件
     */
	HIERARCHY(1L, "层级"),

    /**
     * 文章相关事件
     */
    ARTICLE(2L, "文章");

    /**
     * 事件类型标识（Long类型）
     */
    private final Long code;

    /**
     * 事件类型描述
     */
    private final String description;

    /**
     * 构造方法
     *
     * @param code        事件类型标识
     * @param description 事件类型描述
     */
    EventEnum(Long code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 获取事件类型标识
     *
     * @return 事件类型标识（Long）
     */
    public Long getCode() {
        return code;
    }

    /**
     * 获取事件类型描述
     *
     * @return 事件类型描述
     */
    public String getDescription() {
        return description;
    }

    /**
     * 根据编码获取对应的枚举实例
     *
     * @param code 事件类型编码
     * @return 对应的枚举实例，若不存在则返回null
     */
    public static EventEnum getByCode(Long code) {
        for (EventEnum type : values()) {
            if (type.code.equals(code)) {
                return type;
            }
        }
        return null;
    }
}
