package xyz.zhiwei.article.morphism.support.constant;

/**
 * 审核状态枚举类
 */
public enum CheckStatusEnum {

    /**
     * 编辑中
     */
    EDITING(-1, "编辑中"),

    /**
     * 待审核
     */
    PENDING_REVIEW(0, "待审核"),

    /**
     * 通过
     */
    APPROVED(1, "通过"),

    /**
     * 拒绝
     */
    REJECTED(2, "拒绝");

    private final Integer value;
    private final String name;

    /**
     * 构造方法
     * @param value 状态值
     * @param name 状态名称
     */
    CheckStatusEnum(Integer value, String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * 根据value获取枚举实例
     * @param value 状态值
     * @return 对应的枚举实例
     */
    public static CheckStatusEnum getByValue(Integer value) {
        for (CheckStatusEnum status : values()) {
            if (status.getValue().equals(value)) {
                return status;
            }
        }
        return null;
    }

    /**
     * 获取value
     * @return 状态值
     */
    public Integer getValue() {
        return value;
    }

    /**
     * 获取name
     * @return 状态名称
     */
    public String getName() {
        return name;
    }
}
