package xyz.zhiwei.article.morphism.principle.explorer.qualify;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.PkListQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.PkQualify;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 探索者限定器
 */
public class ExplorerQualify extends BaseQualify<Explorer> implements
															PkQualify<Long,Explorer>,
															PkListQualify<Explorer>{

	public static final ExplorerQualify PQ=new ExplorerQualify();
	
	
	
	/**
	 * 子集限定符：贡献列表里的探索者
	 * @return
	 */
	public PrincipleQualifier<Explorer> contributionList(List<Contribution> contributionList){
		List<Explorer> idList=contributionList.stream()
				.map(c -> new Explorer(c.getExplorerId()))
				.collect(Collectors.toList());

		return pkList(idList);
	}
	

}
