package xyz.zhiwei.article.morphism.principle.edition.qualify;

import xyz.zhiwei.article.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.FkQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.PkQualify;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 版本限定符
 */
public class EditionQualify extends BaseQualify<Edition> implements
														PkQualify<Long,Edition>,
														FkQualify<Edition>{

	public static final EditionQualify PQ=new EditionQualify();

	private static final String DESC_Fk_LastOne="queryLastOne";



	/**
	 * 子集限定符：同一编辑事件的版本列表
	 * @return
	 */
	public PrincipleQualifier<Edition> sameEditEventEditionList(Long eventId){
		Edition eventEdtionConditon=new Edition();
		eventEdtionConditon.setEventId(eventId);
		return fk(eventEdtionConditon);
	}
	
	

	/**
	 * 子集限定符：版本的上一版本
	 * @return
	 */
	public PrincipleQualifier<Edition> lastEdition(Edition thisEdition){
		Edition lastEditionCondition=new Edition();
		lastEditionCondition.setEdition(thisEdition.getEdition());
		lastEditionCondition.setConceptId(thisEdition.getConceptId());
		PrincipleQualifier<Edition> qualifier=new PrincipleQualifier<>(Edition.class,lastEditionCondition);
		qualifier.setDescribe(DESC_Fk_LastOne);
		return qualifier;
	}
	


	/**
	 * 子集限定符：用户此概念上的所有审核版本
	 * @return
	 */
	public PrincipleQualifier<Edition> explorerConceptEditionList(Long authorId,Long conceptId){
		Edition explorerConceptCondition=new Edition();
		explorerConceptCondition.setAuthorId(authorId);
		explorerConceptCondition.setConceptId(conceptId);
		explorerConceptCondition.setCheckStatus(1);
		return fk(explorerConceptCondition);
	}
	
	
}
