package xyz.zhiwei.article.morphism.principle.article.qualify;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualifier.HierarchySuperiorListOnPartCondition;
import xyz.zhiwei.article.morphism.principle.article.qualifier.HierarchySuperiorListOnPartQualifier;
import xyz.zhiwei.article.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.FkListQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.FkQualify;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 层级限定符
 */
public class HierarchyQualify extends BaseQualify<Hierarchy> implements
															FkQualify<Hierarchy>,
															FkListQualify<Hierarchy>{
	public static final HierarchyQualify PQ=new HierarchyQualify();
	
	private static final String DESC_querySuperiorIdListOfList="querySuperiorIdListOfList";
	private static final String DESC_querySuperiorIdListGroup="querySuperiorIdListGroup";
	private static final String DESC_querySuperiorList="querySuperiorList";
	

	/**
	 * 子集限定符：当前概念的直属下级列表
	 * @return
	 */
	public PrincipleQualifier<Hierarchy> subHierarchyQualifier(Long id){
		return fk(new Hierarchy(null,id));
	}
	

	/**
	 * 每个概念的直属下级列表条件
	 * @param init
	 * @return
	 */
    public PrincipleQualifier<Hierarchy> subHierarchyQualifier(List<Hierarchy> hierarchyList){
    	
		List<Hierarchy> supSuerIdCondition=hierarchyList.stream()
				.map(h -> {
					Hierarchy hm=new Hierarchy();
					hm.setSuperiorId(h.getConceptId());
					return hm;
				})
				.collect(Collectors.toList());
    	
    	return fkList(supSuerIdCondition);
    }
	

    

    /**
     * 当前视野内的所有节点的上级直属节点
     * @param thisAndFristHierarchyList
     * @param partIdList
     * @return
     */
    public HierarchySuperiorListOnPartQualifier hierarchySuperiorListOnPartQualifier(List<HierarchySuperiorListOnPartCondition> superiorIdListOnPartConditionList) {
    	HierarchySuperiorListOnPartQualifier pq=new HierarchySuperiorListOnPartQualifier(superiorIdListOnPartConditionList);
    	pq.setDescribe(DESC_querySuperiorIdListOfList);
		return pq;
    }
    
    
    
	/**
	 * 子集限定符：外延直属列表
	 * @return
	 */
	public PrincipleQualifier<Hierarchy> directlySuperiorHierarchyListQualifier(List<Hierarchy> hierarchyList){
		//当前概念的外延直属列表
		PrincipleQualifier<Hierarchy> hierarchyQualifier=new PrincipleQualifier<>(Hierarchy.class,hierarchyList);
		hierarchyQualifier.setDescribe(DESC_querySuperiorIdListGroup);
		return hierarchyQualifier;
	}
	
	/**
	 * 子集限定符：外延直属列表
	 * @return [currentId,....topId]
	 */
	public PrincipleQualifier<Hierarchy> directlySuperiorHierarchyQualifier(Long id){
		//当前概念的外延直属列表
		PrincipleQualifier<Hierarchy> hierarchyQualifier=new PrincipleQualifier<>(Hierarchy.class,new Hierarchy(id));
		hierarchyQualifier.setDescribe(DESC_querySuperiorList);
		return hierarchyQualifier;
	}
    
}
