package xyz.zhiwei.article.morphism.principle.article.qualify;

import xyz.zhiwei.article.morphism.appearance.explorer.viewreview.ContributorReViewInit;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.qualifier.ContributionReviewCondition;
import xyz.zhiwei.article.morphism.principle.article.qualifier.ContributionReviewQualifier;
import xyz.zhiwei.article.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.FkListQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.FkQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.PageQualify;
import xyz.zhiwei.article.morphism.support.facet.PageCondition;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 贡献度限定符
 */
public class ContributionQualify extends BaseQualify<Contribution> implements
															FkQualify<Contribution>,
															FkListQualify<Contribution>,
															PageQualify<Contribution>{

	public static final ContributionQualify PQ=new ContributionQualify();
	private static final String DESC_Fk_conceptIdPositivePage="conceptIdPositivePage";
	private static final String DESC_Fk_conceptIdSpecificPage="conceptIdSpecificPage";

	
	
	/**
	 * 子集限定符：用户的贡献度列表
	 * @return
	 */
	public PrincipleQualifier<Contribution> explorerId(Long explorerId){
		Contribution contributionCondition=new Contribution();
		contributionCondition.setExplorerId(explorerId);
		return fk(contributionCondition);
	}
	
	/**
	 * 子集限定符：概念的正向贡献者分页
	 * @return
	 */
	public PrincipleQualifier<Contribution> conceptIdPositivePage(PageCondition<Long> pageConceptId){
		Contribution contributionCondition=new Contribution();
		contributionCondition.setConceptId(pageConceptId.getSimilar());

		Contribution startCondition=new Contribution();
		startCondition.setContribution(0);

        PrincipleQualifier<Contribution> pq=new PrincipleQualifier<>(getgenericityClass(),contributionCondition,
        		pageConceptId.getPageNum(),pageConceptId.getPageSize());
        pq.setRangeStart(startCondition);
        pq.setDescribe(DESC_Fk_conceptIdPositivePage);
		
		return pq;
	}
	
	
	/**
	 * 子集限定符：概念的特定值贡献者分页
	 * @return
	 */
	public PrincipleQualifier<Contribution> conceptIdSpecificPage(PageCondition<ContributorReViewInit> pageConceptId){
		ContributorReViewInit init=pageConceptId.getSimilar();
		
		Contribution contributionCondition=new Contribution();
		contributionCondition.setConceptId(init.getConceptId());

		ContributionReviewCondition contributionReviewCondition=new ContributionReviewCondition(init.getPassState(),init.getActiveType());

		ContributionReviewQualifier pq=new ContributionReviewQualifier(contributionCondition,pageConceptId.getPageNum(),pageConceptId.getPageSize(),
				contributionReviewCondition);
        pq.setDescribe(DESC_Fk_conceptIdSpecificPage);
		
		return pq;
	}
	

}
