package xyz.zhiwei.article.morphism.principle.article.qualify;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.PkListQualify;
import xyz.zhiwei.article.morphism.principle.base.qualify.PkQualify;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 概念限定符
 */
public class ConceptQualify extends BaseQualify<Concept> implements
														PkQualify<Long,Concept>,
														PkListQualify<Concept>{

public static final ConceptQualify PQ=new ConceptQualify();


	/**
	 * 子集限定符：节点列表
	 * @return
	 */
	public PrincipleQualifier<Concept> hierarchyList(List<Hierarchy> hierarchyList){
		List<Concept> conceptSimilarList = hierarchyList.stream().map(h->new Concept(h)).collect(Collectors.toList());
		return pkList(conceptSimilarList);
	}
	
}
