package xyz.zhiwei.article.morphism.principle.article.model;

import java.util.ArrayList;
import java.util.List;

import xyz.zhiwei.article.morphism.support.util.RandomCode;
import xyz.zhiwei.cognitivedesign.morphism.Principle;

public class ParagraphPicture extends Principle<String> {

	private static final long serialVersionUID = 5142947777041147453L;
	
	

	public ParagraphPicture() {}
	
	public ParagraphPicture(Paragraph paragraph,Long conceptId,Long explorerId,String imageCode) {
		String text=paragraph.getText();
		if(null==text) {
			return;
		}
		if(!text.startsWith("data")){
			return ;
		}
		String imageName=conceptId+"_"+explorerId+"_"+paragraph.getSequence()+"_"+imageCode+".jpg";
		
		setId(imageName);
		setName(text);
	}

	

	
	/**
	 * 从段落列表中取出图片列表
	 * @param paragraphList
	 * @return
	 */
	public static List<ParagraphPicture> paragraphPictureList(List<Paragraph> paragraphList,Long conceptId,Long explorerId){

		List<ParagraphPicture> paragraphPictureList=new ArrayList<>();
		
		
		if(null!=paragraphList){
			for (int i = 0; i < paragraphList.size(); i++) {
				Paragraph oneParagraph=paragraphList.get(i);
				int type=oneParagraph.getType();
				if(2==type){
				 	String imageCode=RandomCode.getRandomCodes(5);
					ParagraphPicture paragraphPicture=new ParagraphPicture(oneParagraph,conceptId,explorerId,imageCode);
					if(null!=paragraphPicture.getId()) {
						oneParagraph.setText(paragraphPicture.getId());
						paragraphPictureList.add(paragraphPicture);
					}
				}
			}
		}
		
		
		
		
		return null;
	}
	
	

}
