package xyz.zhiwei.article.morphism.principle.article.model;

import xyz.zhiwei.article.morphism.principle.article.model.base.StatisticsSuperpositionSelf;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

public class Contribution extends StatisticsSuperpositionSelf{
	private static final long serialVersionUID = 7786879074422942419L;

	private Long conceptId;

    private Long explorerId;

    
    private Integer grade=0;

    private Integer contribution=0;

    private Integer wait=0;

    private Integer refuse=0;
    
    
//    private Integer deep;//深度，0代表到当前深度。
//    private Integer stateActive=0;//查询状态是否有效：0无效，1有效
//    private Integer passState;
//    private Integer activeType;
    
    

    
    public Contribution() {}
    public Contribution(Long id) {
    	setId(id);
    }

    public Contribution(Long conceptId,Long explorerId) {
		Long contributionId=StaticSnowflake.generateId(1, TableIdEnum.CONTRIBUTION.getTableId());
		setId(contributionId);
    	setConceptId(conceptId);
    	setExplorerId(explorerId);
    }
    
    
    public String uniqueKey() {
    	if(null==conceptId || null==explorerId) {
    		return null;
    	}
    	return String.valueOf(conceptId)+"_"+String.valueOf(explorerId);
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getContribution() {
        return contribution;
    }

    public void setContribution(Integer contribution) {
        this.contribution = contribution;
    }

    public Integer getWait() {
        return wait;
    }

    public void setWait(Integer wait) {
        this.wait = wait;
    }

    public Integer getRefuse() {
        return refuse;
    }

    public void setRefuse(Integer refuse) {
        this.refuse = refuse;
    }

	public Long getConceptId() {
		return conceptId;
	}

	public void setConceptId(Long conceptId) {
		this.conceptId = conceptId;
	}

	public Long getExplorerId() {
		return explorerId;
	}

	public void setExplorerId(Long explorerId) {
		this.explorerId = explorerId;
	}

}