package xyz.zhiwei.article.morphism.facet.paragraph;

import java.util.ArrayList;
import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.article.model.ParagraphPicture;
import xyz.zhiwei.article.morphism.support.util.RandomCode;

/**
 * 段落列表
 */
public class ParagraphList extends ArrayList<Paragraph>{
	private static final long serialVersionUID = 1L;

	

	public ParagraphList(List<Paragraph> paragraphList) {
		this.addAll(paragraphList);
	}
	
	

	/**
	 * 从段落列表中取出图片列表
	 * @param paragraphList
	 * @return
	 */
	public List<ParagraphPicture> paragraphPictureList(Long explorerId,Long conceptId){
		List<Paragraph> paragraphList=this;
		
		List<ParagraphPicture> paragraphPictureList=new ArrayList<>();
		
		
		if(null!=paragraphList){
			for (int i = 0; i < paragraphList.size(); i++) {
				Paragraph oneParagraph=paragraphList.get(i);
				int type=oneParagraph.getType();
				if(2==type){
				 	String imageCode=RandomCode.getRandomCodes(5);
					ParagraphPicture paragraphPicture=new ParagraphPicture(oneParagraph,conceptId,explorerId,imageCode);
					if(null!=paragraphPicture.getId()) {
						oneParagraph.setText(paragraphPicture.getId());
						paragraphPictureList.add(paragraphPicture);
					}
				}
			}
		}
		
		return null;
	}
    
    
	
}
