package xyz.zhiwei.article.morphism.facet.contribution;

import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.support.facet.LinkTwoListFacet;
import xyz.zhiwei.article.morphism.support.facet.Page;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSourcePage;

/**
 * 贡献者列表分页
 */
public class ContributionExplorerPage extends Page<ContributionExplorerFacet>{
	private static final long serialVersionUID = 1L;
	
	
	/**
	 * 
	 * @param contributionList
	 * @param explorerList
	 */
	public ContributionExplorerPage(List<Contribution> contributionList,List<Explorer> explorerList) {
		
		LinkTwoListFacet<ContributionExplorerFacet> linkTwoListFacet=new LinkTwoListFacet<>(
				contributionList,explorerList,Contribution::getExplorerId, Explorer::getId,
				ContributionExplorerFacet::new);

		Long total=((PrincipleSourcePage<Contribution>)contributionList).getTotal();
		
		this.addAll(linkTwoListFacet);
		this.setTotal(total);
	}
	

}
