package xyz.zhiwei.article.morphism.facet.contribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import xyz.zhiwei.article.morphism.facet.hierarchy.HierarchyFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.support.util.HierarchyMapper;

/**
 * 带特定贡献值的概念模型
 * @author:Aureole
 */
public class ConceptContributionViewFacet extends Concept{

	private static final long serialVersionUID = 164045285341581265L;
	
	private Long superiorId;
    private Integer sequence;
	private boolean active;//此三字段的注解见HierarchyFacet
	private boolean connotationList;
	private boolean containConnotation;
	
	private Contribution contribution;

	private List<ConceptContributionViewFacet> inferiorList;

	public ConceptContributionViewFacet() {}
	
	/**
	 * 层级构造
	 * @param hierarchyFacet
	 */
	public ConceptContributionViewFacet(HierarchyFacet hierarchyFacet) {
		super(hierarchyFacet);
		this.superiorId=hierarchyFacet.getSuperiorId();
		this.sequence=hierarchyFacet.getSequence();
		this.active=hierarchyFacet.isActive();
		this.connotationList=hierarchyFacet.isConnotationList();
		this.containConnotation=hierarchyFacet.isContainConnotation();
		
		List<HierarchyFacet> inferiorHierarchyList=hierarchyFacet.getInferiorList();
		if(null!=inferiorHierarchyList) {
			List<ConceptContributionViewFacet> inferiorList=new ArrayList<>();
			for(HierarchyFacet inferior:inferiorHierarchyList) {
				inferiorList.add(new ConceptContributionViewFacet(inferior));
			}
			this.inferiorList=inferiorList;
		}
	}
	
	/**
	 * 把层级结构构造为概念贡献层级
	 * @param hierarchyFacet
	 * @param conceptList
	 * @param contributionList
	 */
	public ConceptContributionViewFacet(HierarchyFacet hierarchyFacet,List<Concept> conceptList,List<Contribution> contributionList){
		this(hierarchyFacet);
		
		Map<Long,ConceptContributionViewFacet> conceptMap=HierarchyMapper.getTMapFormTopT(this, ConceptContributionViewFacet::getId, ConceptContributionViewFacet::getInferiorList);

		HierarchyMapper.updateTData(conceptMap, conceptList, Concept::getId, ConceptContributionViewFacet::fillConceptModelWithData);
		HierarchyMapper.updateTData(conceptMap, contributionList, Contribution::getConceptId, ConceptContributionViewFacet::setContribution);
		
	}
	
	
	
	
	

	public Contribution getContribution() {
		return contribution;
	}

	public void setContribution(Contribution contribution) {
		this.contribution = contribution;
	}

	public List<ConceptContributionViewFacet> getInferiorList() {
		return inferiorList;
	}

	public void setInferiorList(List<ConceptContributionViewFacet> inferiorList) {
		this.inferiorList = inferiorList;
	}

	public Long getSuperiorId() {
		return superiorId;
	}

	public Integer getSequence() {
		return sequence;
	}

	public boolean isActive() {
		return active;
	}

	public boolean isConnotationList() {
		return connotationList;
	}

	public boolean isContainConnotation() {
		return containConnotation;
	}
	

}