package xyz.zhiwei.article.morphism.facet.concept;

import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;


/**
 * @author:Aureole
 */
public class ConceptUpdateCountFacet {

	private List<Long> superiorIdList;
	
	private Long conceptId;
	
	
    private Integer countAll=0;

    private Integer countCreate=0;

    private Integer countEditCompOrArt=0;

    private Integer countDiscussion=0;

    
    private Integer isAll=0;

    private Integer isCreate=0;

    private Integer isEditCompOrArt=0;

    private Integer isDiscussion=0;

	
    public ConceptUpdateCountFacet() {}
    
    public ConceptUpdateCountFacet(List<Long> superiorIdList) {
    	this.superiorIdList=superiorIdList;
    }
    

    
    /**
     * 版本请求：更新数转为概念数
     * @param conceptUpdateCountFacet
     * @return
     */
	public Concept requestToConcept() {
		ConceptUpdateCountFacet conceptUpdateCountFacet=this;
		
		Concept concept=new Concept(conceptUpdateCountFacet.getConceptId());
		
		concept.setWaitCountAll(conceptUpdateCountFacet.getCountAll());
		concept.setWaitCountCreate(conceptUpdateCountFacet.getCountCreate());
		concept.setWaitCountEdit(conceptUpdateCountFacet.getCountEditCompOrArt());
		concept.setWaitCountDiscussion(conceptUpdateCountFacet.getCountDiscussion());
		

		concept.setWaitIsAll(conceptUpdateCountFacet.getIsAll());
		concept.setWaitIsCreate(conceptUpdateCountFacet.getIsCreate());
		concept.setWaitIsEdit(conceptUpdateCountFacet.getIsEditCompOrArt());
		concept.setWaitIsDiscussion(conceptUpdateCountFacet.getIsDiscussion());
		
		return concept;
	}
    
	/**
	 * 版本请求：更新数转为贡献数
	 * @param conceptUpdateCountFacet
	 * @param explorerId
	 * @return
	 */
    public Contribution requestToContribution(Long explorerId) {
    	ConceptUpdateCountFacet conceptUpdateCountFacet=this;
    	Contribution contribution=new Contribution(conceptUpdateCountFacet.getConceptId(), explorerId);
    	
    	contribution.setWaitCountAll(conceptUpdateCountFacet.getCountAll());
    	contribution.setWaitCountCreate(conceptUpdateCountFacet.getCountCreate());
    	contribution.setWaitCountEdit(conceptUpdateCountFacet.getCountEditCompOrArt());
    	contribution.setWaitCountDiscussion(conceptUpdateCountFacet.getCountDiscussion());
    	
    	
    	
    	contribution.setWaitIsAll(conceptUpdateCountFacet.getIsAll());
    	contribution.setWaitIsCreate(conceptUpdateCountFacet.getIsCreate());
    	contribution.setWaitIsEdit(conceptUpdateCountFacet.getIsEditCompOrArt());
    	contribution.setWaitIsDiscussion(conceptUpdateCountFacet.getIsDiscussion());
    	
    	return contribution;
    }
	
    /**
     * 转换成通过概念统计值
     * @param updateCountModel
     * @param explorerId
     * @return
     */
	public Concept acceptToConcept(){
		ConceptUpdateCountFacet updateCountModel=this;
		Concept conceptModel=new Concept();
		conceptModel.setId(updateCountModel.getConceptId());
		
		
		conceptModel.setCenturyCountAll(updateCountModel.getCountAll());
		conceptModel.setCenturyCountCreate(updateCountModel.getCountCreate());
		conceptModel.setCenturyCountEdit(updateCountModel.getCountEditCompOrArt());
		conceptModel.setCenturyCountDiscussion(updateCountModel.getCountDiscussion());
		
		conceptModel.setCenturyIsAll(updateCountModel.getIsAll());
		conceptModel.setCenturyIsCreate(updateCountModel.getIsCreate());
		conceptModel.setCenturyIsEdit(updateCountModel.getIsEditCompOrArt());
		conceptModel.setCenturyIsDiscussion(updateCountModel.getIsDiscussion());
		
		
		conceptModel.setWaitCountAll(-updateCountModel.getCountAll());
		conceptModel.setWaitCountCreate(-updateCountModel.getCountCreate());
		conceptModel.setWaitCountEdit(-updateCountModel.getCountEditCompOrArt());
		conceptModel.setWaitCountDiscussion(-updateCountModel.getCountDiscussion());
		
		conceptModel.setWaitIsAll(-updateCountModel.getIsAll());
		conceptModel.setWaitIsCreate(-updateCountModel.getIsCreate());
		conceptModel.setWaitIsEdit(-updateCountModel.getIsEditCompOrArt());
		conceptModel.setWaitIsDiscussion(-updateCountModel.getIsDiscussion());
		
		return conceptModel;
	}

    /**
     * 转换成通过贡献值
     * @param updateCountModel
     * @param explorerId
     * @return
     */
    public Contribution acceptToContribution(Long explorerId){
    	ConceptUpdateCountFacet updateCountModel=this;
    	Contribution contributionModel=new Contribution();
    	contributionModel.setExplorerId(explorerId);
    	contributionModel.setConceptId(updateCountModel.getConceptId());
    	
    	
    	contributionModel.setCenturyCountAll(updateCountModel.getCountAll());
    	contributionModel.setCenturyCountCreate(updateCountModel.getCountCreate());
    	contributionModel.setCenturyCountEdit(updateCountModel.getCountEditCompOrArt());
    	contributionModel.setCenturyCountDiscussion(updateCountModel.getCountDiscussion());
    	
    	
    	contributionModel.setCenturyIsAll(updateCountModel.getIsAll());
    	contributionModel.setCenturyIsCreate(updateCountModel.getIsCreate());
    	contributionModel.setCenturyIsEdit(updateCountModel.getIsEditCompOrArt());
    	contributionModel.setCenturyIsDiscussion(updateCountModel.getIsDiscussion());
    	
    	
    	contributionModel.setWaitCountAll(-updateCountModel.getCountAll());
    	contributionModel.setWaitCountCreate(-updateCountModel.getCountCreate());
    	contributionModel.setWaitCountEdit(-updateCountModel.getCountEditCompOrArt());
    	contributionModel.setWaitCountDiscussion(-updateCountModel.getCountDiscussion());
    	
    	
    	contributionModel.setWaitIsAll(-updateCountModel.getIsAll());
    	contributionModel.setWaitIsCreate(-updateCountModel.getIsCreate());
    	contributionModel.setWaitIsEdit(-updateCountModel.getIsEditCompOrArt());
    	contributionModel.setWaitIsDiscussion(-updateCountModel.getIsDiscussion());
    	
    	return contributionModel;
    }
    
    /**
     * 转换成拒绝概念统计值
     * @param updateCountModel
     * @param explorerId
     * @return
     */
	public Concept refuseToConcept(){
		ConceptUpdateCountFacet updateCountModel=this;
		Concept conceptModel=new Concept();
		conceptModel.setId(updateCountModel.getConceptId());
		
		
		conceptModel.setRefuseCountAll(updateCountModel.getCountAll());
		conceptModel.setRefuseCountCreate(updateCountModel.getCountCreate());
		conceptModel.setRefuseCountEdit(updateCountModel.getCountEditCompOrArt());
		conceptModel.setRefuseCountDiscussion(updateCountModel.getCountDiscussion());
		
		
		conceptModel.setRefuseIsAll(updateCountModel.getIsAll());
		conceptModel.setRefuseIsCreate(updateCountModel.getIsCreate());
		conceptModel.setRefuseIsEdit(updateCountModel.getIsEditCompOrArt());
		conceptModel.setRefuseIsDiscussion(updateCountModel.getIsDiscussion());
		
		
		conceptModel.setWaitCountAll(-updateCountModel.getCountAll());
		conceptModel.setWaitCountCreate(-updateCountModel.getCountCreate());
		conceptModel.setWaitCountEdit(-updateCountModel.getCountEditCompOrArt());
		conceptModel.setWaitCountDiscussion(-updateCountModel.getCountDiscussion());
		
		conceptModel.setWaitIsAll(-updateCountModel.getIsAll());
		conceptModel.setWaitIsCreate(-updateCountModel.getIsCreate());
		conceptModel.setWaitIsEdit(-updateCountModel.getIsEditCompOrArt());
		conceptModel.setWaitIsDiscussion(-updateCountModel.getIsDiscussion());
		
		return conceptModel;
	}
    
    /**
     * 转换成拒绝贡献值
     * @param updateCountModel
     * @param explorerId
     * @return
     */
    public Contribution refuseToContribution(Long explorerId){
    	ConceptUpdateCountFacet updateCountModel=this;
    	Contribution contributionModel=new Contribution();
    	contributionModel.setExplorerId(explorerId);
    	contributionModel.setConceptId(updateCountModel.getConceptId());
    	
    	
    	contributionModel.setRefuseCountAll(updateCountModel.getCountAll());
    	contributionModel.setRefuseCountCreate(updateCountModel.getCountCreate());
    	contributionModel.setRefuseCountEdit(updateCountModel.getCountEditCompOrArt());
    	contributionModel.setRefuseCountDiscussion(updateCountModel.getCountDiscussion());
    	
    	
    	contributionModel.setRefuseIsAll(updateCountModel.getIsAll());
    	contributionModel.setRefuseIsEdit(updateCountModel.getIsEditCompOrArt());
    	contributionModel.setRefuseIsCreate(updateCountModel.getIsCreate());
    	contributionModel.setRefuseIsDiscussion(updateCountModel.getIsDiscussion());
    	
    	
    	contributionModel.setWaitCountAll(-updateCountModel.getCountAll());
    	contributionModel.setWaitCountCreate(-updateCountModel.getCountCreate());
    	contributionModel.setWaitCountEdit(-updateCountModel.getCountEditCompOrArt());
    	contributionModel.setWaitCountDiscussion(-updateCountModel.getCountDiscussion());
    	
    	contributionModel.setWaitIsAll(-updateCountModel.getIsAll());
    	contributionModel.setWaitIsEdit(-updateCountModel.getIsEditCompOrArt());
    	contributionModel.setWaitIsCreate(-updateCountModel.getIsCreate());
    	contributionModel.setWaitIsDiscussion(-updateCountModel.getIsDiscussion());
    	
    	return contributionModel;
    }
    
    
	
	public Integer getCountAll() {
		return countAll;
	}

	public void setCountAll(Integer countAll) {
		this.countAll = countAll;
	}

	public Integer getCountCreate() {
		return countCreate;
	}

	public void setCountCreate(Integer countCreate) {
		this.countCreate = countCreate;
	}

	public Integer getCountEditCompOrArt() {
		return countEditCompOrArt;
	}

	public void setCountEditCompOrArt(Integer countEditCompOrArt) {
		this.countEditCompOrArt = countEditCompOrArt;
	}

	public Integer getCountDiscussion() {
		return countDiscussion;
	}

	public void setCountDiscussion(Integer countDiscussion) {
		this.countDiscussion = countDiscussion;
	}


	public Integer getIsAll() {
		return isAll;
	}

	public void setIsAll(Integer isAll) {
		this.isAll = isAll;
	}

	public Integer getIsCreate() {
		return isCreate;
	}

	public void setIsCreate(Integer isCreate) {
		this.isCreate = isCreate;
	}

	public Integer getIsEditCompOrArt() {
		return isEditCompOrArt;
	}

	public void setIsEditCompOrArt(Integer isEditCompOrArt) {
		this.isEditCompOrArt = isEditCompOrArt;
	}

	public Integer getIsDiscussion() {
		return isDiscussion;
	}

	public void setIsDiscussion(Integer isDiscussion) {
		this.isDiscussion = isDiscussion;
	}

	public List<Long> getSuperiorIdList() {
		return superiorIdList;
	}

	public void setSuperiorIdList(List<Long> superiorIdList) {
		this.superiorIdList = superiorIdList;
	}

	public Long getConceptId() {
		return conceptId;
	}

	public void setConceptId(Long conceptId) {
		this.conceptId = conceptId;
	}


}
