package xyz.zhiwei.article.morphism.facet.concept;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.support.facet.AddAndUpdateGroupFacet;

/**
 * 概念统计合并数
 */
public class ConceptUpdateCountCombineListFacet extends ArrayList<ConceptUpdateCountFacet>{

	private static final long serialVersionUID = -2544606601210572690L;
	
	//临时变量：更新统计数转贡献列表
	private List<Contribution> contributionList;

	
	public ConceptUpdateCountCombineListFacet() {}

	
	/**
	 * 单个概念统计数合并
	 * @param conceptUpdateCountFacet
	 */
	public ConceptUpdateCountCombineListFacet(ConceptUpdateCountFacet conceptUpdateCountFacet) {
		this(List.of(conceptUpdateCountFacet));
	}
	
	/**
	 * 多个概念统计数合并
	 * @param conceptUpdateCountFacetList
	 */
	public ConceptUpdateCountCombineListFacet(List<ConceptUpdateCountFacet> conceptUpdateCountFacetList) {

		if(null==conceptUpdateCountFacetList || conceptUpdateCountFacetList.size()==0){
			return;
		}
		
		Map<Long,ConceptUpdateCountFacet> updateCountMap=new HashMap<>();
		
		for (int i = 0; i < conceptUpdateCountFacetList.size(); i++) {
			ConceptUpdateCountFacet oneUpdateCountModel=conceptUpdateCountFacetList.get(i);
			List<Long> superiorIdList=oneUpdateCountModel.getSuperiorIdList();
			//累计值
			for (int j = 0; j < superiorIdList.size(); j++) {
				Long oneSuperiorId=superiorIdList.get(j);
				ConceptUpdateCountFacet combineUpdateCountModel=updateCountMap.get(oneSuperiorId);
				if(null==combineUpdateCountModel){
					combineUpdateCountModel=new ConceptUpdateCountFacet();
					combineUpdateCountModel.setConceptId(oneSuperiorId);
					updateCountMap.put(oneSuperiorId, combineUpdateCountModel);
				}
				combineUpdateCountModel.setCountCreate(combineUpdateCountModel.getCountCreate()+oneUpdateCountModel.getCountCreate());
				combineUpdateCountModel.setCountEditCompOrArt(combineUpdateCountModel.getCountEditCompOrArt()+oneUpdateCountModel.getCountEditCompOrArt());
				combineUpdateCountModel.setCountDiscussion(combineUpdateCountModel.getCountDiscussion()+oneUpdateCountModel.getCountDiscussion());
			}

			//当前值
			Long lastSupId=superiorIdList.get(superiorIdList.size()-1);
			ConceptUpdateCountFacet combineUpdateCountModel=updateCountMap.get(lastSupId);
			combineUpdateCountModel.setIsCreate(combineUpdateCountModel.getIsCreate()+oneUpdateCountModel.getIsCreate());
			combineUpdateCountModel.setIsEditCompOrArt(combineUpdateCountModel.getIsEditCompOrArt()+oneUpdateCountModel.getIsEditCompOrArt());
			combineUpdateCountModel.setIsDiscussion(combineUpdateCountModel.getIsDiscussion()+oneUpdateCountModel.getIsDiscussion());
		}
		
		
		for (Long id:updateCountMap.keySet()) {
			ConceptUpdateCountFacet oneUpdateCountModel=updateCountMap.get(id);
			oneUpdateCountModel.setCountAll(oneUpdateCountModel.getCountCreate()+oneUpdateCountModel.getCountEditCompOrArt()+oneUpdateCountModel.getCountDiscussion());
			
			oneUpdateCountModel.setIsAll(oneUpdateCountModel.getIsCreate()+oneUpdateCountModel.getIsEditCompOrArt()+oneUpdateCountModel.getIsDiscussion());
			
			
			this.add(oneUpdateCountModel);
		}
		
	}
	
	

    /**
     * 统计数转概念列表
     * @param combineUpdateConutList
     * @return
     */
	public List<Concept> getUpdateCountToConceptList(Function<ConceptUpdateCountFacet,Concept> toConceptFun) {
	    return this.stream()
	               .map(toConceptFun)
	               .collect(Collectors.toList());
	}
	

	
    /**
     * 更新统计数转贡献列表
     * @param combineUpdateConutList
     * @param explorerId
     * @return
     */
	public List<Contribution> getUpdateContributionList(Long explorerId,BiFunction<ConceptUpdateCountFacet, Long, Contribution> toContributionFun) {
	    return this.stream()
	    		   .map(oneUpdateCount -> toContributionFun.apply(oneUpdateCount, explorerId))
	               .collect(Collectors.toList());
	}
	
	
    /**
     * 更新统计数转贡献列表
     * @param combineUpdateConutList
     * @param explorerId
     * @param userContributionList 用户已存在的的贡献值列表
     * @return
     */
	public List<Contribution> getUpdateCountToContributionList(Long explorerId,List<Contribution> userContributionList,BiFunction<ConceptUpdateCountFacet, Long, Contribution> toContributionFun) {
		if(null==this.contributionList) {
			List<Contribution> contributionList=this.getUpdateContributionList(explorerId,toContributionFun);
			this.contributionList=contributionList;
		}
		//=====贡献数分为新增和更新====
	    AddAndUpdateGroupFacet<Contribution> contributionGroup=new AddAndUpdateGroupFacet<>(this.contributionList, userContributionList,
				Contribution::uniqueKey, Contribution::getId, Contribution::setId);

		return contributionGroup.getModification();
	} 
	
    /**
     * 新增统计数转贡献列表
     * @param combineUpdateConutList
     * @param explorerId
     * @param userContributionList 用户已存在的的贡献值列表
     * @return
     */
	public List<Contribution> getNewCountToContributionList(Long explorerId,List<Contribution> userContributionList,BiFunction<ConceptUpdateCountFacet, Long, Contribution> toContributionFun) {
		if(null==this.contributionList) {
			List<Contribution> contributionList=this.getUpdateContributionList(explorerId,toContributionFun);
			this.contributionList=contributionList;
		}
		//=====贡献数分为新增和更新====
	    AddAndUpdateGroupFacet<Contribution> contributionGroup=new AddAndUpdateGroupFacet<>(this.contributionList, userContributionList,
				Contribution::uniqueKey, Contribution::getId, Contribution::setId);

		return contributionGroup.getAddition();
	} 
	
}
