package xyz.zhiwei.article.morphism.facet.concept;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import xyz.zhiwei.article.morphism.facet.hierarchy.HierarchyFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.support.util.HierarchyMapper;

/**
 * 带层级信息的概念模型
 */
public class ConceptHierarchyFacet extends Concept{
	private static final long serialVersionUID = 1L;


	private Long superiorId;
    private Integer sequence;
	private boolean active;//此三字段的注解见HierarchyFacet
	private boolean connotationList;
	private boolean containConnotation;

	private List<ConceptHierarchyFacet> inferiorList;
	
	
	public ConceptHierarchyFacet(HierarchyFacet hierarchyFacet){
		super(hierarchyFacet);
		this.superiorId=hierarchyFacet.getSuperiorId();
		this.sequence=hierarchyFacet.getSequence();
		this.active=hierarchyFacet.isActive();
		this.connotationList=hierarchyFacet.isConnotationList();
		this.containConnotation=hierarchyFacet.isContainConnotation();
		
		List<HierarchyFacet> inferiorHierarchyList=hierarchyFacet.getInferiorList();
		if(null!=inferiorHierarchyList) {
			List<ConceptHierarchyFacet> inferiorList=new ArrayList<>();
			for(HierarchyFacet inferior:inferiorHierarchyList) {
				inferiorList.add(new ConceptHierarchyFacet(inferior));
			}
			this.inferiorList=inferiorList;
		}
	}


	/**
	 * 把层级结构构造为概念层级
	 * @param hierarchyFacet
	 * @param conceptList
	 * @param contributionList
	 */
	public ConceptHierarchyFacet(HierarchyFacet hierarchyFacet,List<Concept> conceptList){
		this(hierarchyFacet);
		
		Map<Long,ConceptHierarchyFacet> conceptMap=HierarchyMapper.getTMapFormTopT(this, ConceptHierarchyFacet::getId, ConceptHierarchyFacet::getInferiorList);

		HierarchyMapper.updateTData(conceptMap, conceptList, Concept::getId, ConceptHierarchyFacet::fillConceptModelWithData);
		
	}
	
	

	public Long getSuperiorId() {
		return superiorId;
	}


	public Integer getSequence() {
		return sequence;
	}


	public boolean isActive() {
		return active;
	}


	public boolean isConnotationList() {
		return connotationList;
	}


	public List<ConceptHierarchyFacet> getInferiorList() {
		return inferiorList;
	}


	public boolean isContainConnotation() {
		return containConnotation;
	}
	
	
}
