package xyz.zhiwei.article.morphism.appearance.hierarchy.request;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.article.qualifier.HierarchySuperiorListOnPartCondition;
import xyz.zhiwei.article.morphism.principle.edition.model.EditEvent;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.edition.model.base.Connotation;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.DeepClone;
import xyz.zhiwei.article.morphism.support.util.ListMapper;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

/**
 * 解开层级后的列表
 */
class WaitHierarchyListFacet extends ArrayList<WaitHierarchyFacet>{
	private static final long serialVersionUID = 1L;
	private static final Long WaitConceptIdSign = 1L;

	/**
	 * 解层级
	 * @param init
	 */
	WaitHierarchyListFacet(HierarchyRequestInit init){
		WaitHierarchyFacet waitHierarchyFacet=new WaitHierarchyFacet(init);
		
		//目标列表
		List<WaitHierarchyFacet> list=new ArrayList<>();
		
		//递归数据结构定义
		List<WaitHierarchyFacet> nowList=new ArrayList<>();
		List<WaitHierarchyFacet> nextList=new ArrayList<>();
		
		//初始化
		nowList.add(waitHierarchyFacet);
		//递归准入条件
		while(nowList.size()>0){
			for (int i = 0; i < nowList.size(); i++) {
				WaitHierarchyFacet oneNow=nowList.get(i);
				List<WaitHierarchyFacet> inferiorList=oneNow.getInferiorList();
				
				Long id=oneNow.getId();
				
				//补充新增id
				if(null==id){
					Long newId=StaticSnowflake.generateId(1, TableIdEnum.CONCEPT.getTableId());
					oneNow.setConceptId(newId);
					oneNow.setWaitConceptId(WaitConceptIdSign);
				}
				
				//添加序号,supId
				if(null!=inferiorList && inferiorList.size()>0){
					for (int j = 0; j < inferiorList.size(); j++) {
						WaitHierarchyFacet inferior=inferiorList.get(j);
						inferior.setSuperiorId(id);
					}
				}
				
				list.add(oneNow);
				if(null!=inferiorList) {
					nextList.addAll(inferiorList);
				}
			}

			//重置列表
			nowList=nextList;
			nextList=new ArrayList<WaitHierarchyFacet>();
		}
		
		
		
		//只要显示等级小于等于1的
    	List<WaitHierarchyFacet> thisAndOneWaitHierarchyList=list.stream().filter(w->w.getShowEditLevel()<=1).collect(Collectors.toList());
		
		
		this.addAll(thisAndOneWaitHierarchyList);
	}
	
	
	
	

	/**
	 * 当前更新涉及到的所有已有ID的当前节点和下一级节点
	 * @return
	 */
    List<Hierarchy> getExistHierarchyList(){
    	List<WaitHierarchyFacet> thisAndOneWaitHierarchyList=this;
    	
    	List<Hierarchy> thisAndOneTwoHierarchyList=new ArrayList<Hierarchy>();
    	for (WaitHierarchyFacet waitHierarchyOne : thisAndOneWaitHierarchyList) {
    		Hierarchy oneHierarchy=waitHierarchyOne.toHierarchy();
    		if(!WaitConceptIdSign.equals(waitHierarchyOne.getWaitConceptId())) {
        		thisAndOneTwoHierarchyList.add(oneHierarchy);
    		}
			List<WaitHierarchyFacet> inferiorList=waitHierarchyOne.getInferiorList();
			for (WaitHierarchyFacet oneInferior : inferiorList) {
	    		Hierarchy oneInferiorHierarchy=oneInferior.toHierarchy();
	    		if(!WaitConceptIdSign.equals(oneInferior.getWaitConceptId())) {
	        		thisAndOneTwoHierarchyList.add(oneInferiorHierarchy);
	    		}
			}
		}
    	return thisAndOneTwoHierarchyList;
    }
	

	/**
	 * 当前更新涉及到的所有已有ID的当前节点和下一级节点
	 * 以及这些节点的下级节点
	 * @return
	 */
    List<Hierarchy> getExistHierarchyListWithSubHierarchy(List<Hierarchy> thisAndOneSubHierarchyAllList){
    	List<Hierarchy> thisAndOneTwoHierarchyList=getExistHierarchyList();
		List<Hierarchy> mergedList = Stream.concat(thisAndOneTwoHierarchyList.stream(), thisAndOneSubHierarchyAllList.stream()).collect(Collectors.toList());
		return mergedList;
    }
	

    
	/**
	 * 
	 * 分析概念的组分差异：
	 * 
	 * 添加组分
	 * 删除组分
	 * 重排组分
	 * 并设置编辑状态1
	 * 
	 * 生成内涵空间更新列表
	 * 
	 * @param hierarchyList
	 * @param conceptList
	 */
    void updateCompareComponent(List<Hierarchy> hierarchyList,List<Concept> conceptList){
		List<WaitHierarchyFacet> waithierarchyList=this;
		//原集索引
    	Map<Long, Concept> conceptMap = conceptList.stream().collect(Collectors.toMap(Concept::getId, Function.identity()));
    	//层级分组
    	List<Hierarchy> supHierarchyIdList=this.stream().map(wm -> wm.toHierarchy()).collect(Collectors.toList());
    	Map<Long,Map<Long,Hierarchy>> hierarchyGroupMap=groupBySuperId(supHierarchyIdList,hierarchyList);
		
		
		
		
		for(WaitHierarchyFacet newConcetp:waithierarchyList){
			List<WaitHierarchyFacet> levelOneList=newConcetp.getInferiorList();
			List<ConnotationDifference> connotationDifferenceList=new ArrayList<>();
			newConcetp.setConnotationDifferenceList(connotationDifferenceList);
			
			//================当前概念是新概念================
			Long waitId=newConcetp.getWaitConceptId();
			if(1L==waitId){
				if(null!=levelOneList && levelOneList.size()>0){
					newConcetp.setAddComp(1);
					newConcetp.setIsEditComp(1);

					for (int i = 0; i < levelOneList.size(); i++) {
						WaitHierarchyFacet oneLevelOne=levelOneList.get(i);
						ConnotationDifference cm=new ConnotationDifference();
						cm.setUpdateType(1);
						cm.setName(oneLevelOne.getName());
						cm.setConceptId(oneLevelOne.getConceptId());
						cm.setWaitConceptId(oneLevelOne.getWaitConceptId());
						connotationDifferenceList.add(cm);
					}
				}
				continue;
			}
			

			//================当前概念是已有概念================
//			if(newConcetp.getOrderComp()!=-1){
//				continue;
//			}
			
			
			Map<Long,Concept> levelOneMapDb=new HashMap<>();
			Map<Long,WaitHierarchyFacet> levelOneMap=ListMapper.getMapOfList(levelOneList);
			
			//查询库存
			Map<Long,Hierarchy> subHierarchyMap=hierarchyGroupMap.get(newConcetp.getConceptId());
			//========组分分析==========
			//全新组分
			if(null==subHierarchyMap || subHierarchyMap.isEmpty() ){
				if(null!=levelOneList && levelOneList.size()>0){
					newConcetp.setAddComp(1);
					newConcetp.setIsEditComp(1);

					for (int i = 0; i < levelOneList.size(); i++) {
						WaitHierarchyFacet oneLevelOne=levelOneList.get(i);
						ConnotationDifference cm=new ConnotationDifference();
						cm.setUpdateType(1);
						cm.setName(oneLevelOne.getName());
						cm.setConceptId(oneLevelOne.getConceptId());
						cm.setWaitConceptId(oneLevelOne.getWaitConceptId());
						connotationDifferenceList.add(cm);
					}
					
				}
			}else{
				//组分对比
				//索引
				for(Long subId:subHierarchyMap.keySet()) {
					//conceptDbForName.put(levelOneListDb.get(i).getId(), levelOneListDb.get(i));
					levelOneMapDb.put(subId, conceptMap.get(subId));
				}
				
				//检查添加组分
				if(null!=levelOneList){
					for (int i = 0; i < levelOneList.size(); i++) {
						WaitHierarchyFacet oneHierarchyModel=levelOneList.get(i);
						if(!levelOneMapDb.containsKey(oneHierarchyModel.getConceptId())){
							newConcetp.setAddComp(1);
							newConcetp.setIsEditComp(1);
							
							ConnotationDifference cm=new ConnotationDifference();
							cm.setUpdateType(1);
							cm.setName(oneHierarchyModel.getName());
							cm.setConceptId(oneHierarchyModel.getConceptId());
							cm.setWaitConceptId(oneHierarchyModel.getWaitConceptId());
							connotationDifferenceList.add(cm);
						}
					}
				}
				
				//检查删除组分
				for(Long subId:subHierarchyMap.keySet()) {
					Concept oneConceptModelDb=conceptMap.get(subId);
					if(!levelOneMap.containsKey(oneConceptModelDb.getId())){
						newConcetp.setDelComp(1);
						newConcetp.setIsEditComp(1);

						ConnotationDifference cm=new ConnotationDifference();
						cm.setUpdateType(2);
						cm.setName(oneConceptModelDb.getName());
						cm.setConceptId(oneConceptModelDb.getId());
						connotationDifferenceList.add(cm);

					}
				}
					
				//检查重排
				List<Hierarchy> orderHierarchyOfDb=subHierarchyMap.values().stream()
		                .sorted(Comparator.comparingInt(Hierarchy::getSequence)) 
		                .collect(Collectors.toList());
				
				if(newConcetp.getIsEditComp()==0 && null!=levelOneList){
					for (int i = 0; i < levelOneList.size(); i++) {
						WaitHierarchyFacet oneHierarchyModel=levelOneList.get(i);
						Hierarchy oneConceptModelDb=orderHierarchyOfDb.get(i);
						if(!oneHierarchyModel.getConceptId().equals(oneConceptModelDb.getId())){
							newConcetp.setOrderComp(1);
							newConcetp.setIsEditComp(1);
							

							ConnotationDifference cm=new ConnotationDifference();
							cm.setUpdateType(3);
							cm.setName("组分重排");
							connotationDifferenceList.add(cm);

							break;
						}
					}
				}
			}
					
		}

	}

	
	
	/**
	 * 把列表套到上级列表上
	 * @param supHierarchyIdList
	 * @param hierarchyList
	 * @return
	 */
	private Map<Long,Map<Long,Hierarchy>> groupBySuperId(List<Hierarchy> supHierarchyIdList,List<Hierarchy> hierarchyList){
		Map<Long,Map<Long,Hierarchy>> supMap=new HashMap<>();
		
		for(Hierarchy sup:supHierarchyIdList) {
			if(null==sup.getConceptId()) {
				continue;
			}
			supMap.put(sup.getConceptId(), new HashMap<Long,Hierarchy>());
		}
		
		for(Hierarchy sub:hierarchyList) {
			if(null==sub.getSuperiorId()) {
				continue;
			}
			Map<Long,Hierarchy> subMap=supMap.get(sub.getSuperiorId());
			if(null!=subMap) {
				subMap.put(sub.getConceptId(), sub);
			}
		}
		
		return supMap;
	}

	/**
	 * 名称分析
	 * 新概念，设置新增状态1
	 * 自身改名，改名状态1, 父组分改名状态1，父组分编辑状态1
	 * @param waithierarchyMap
	 * @param conceptDbMap
	 */
	void updateCompareConceptName(List<Concept> conceptList){

		List<WaitHierarchyFacet> waithierarchyList=this;
		//原集索引
    	Map<Long, Concept> conceptMap = conceptList.stream().collect(Collectors.toMap(Concept::getId, Function.identity()));
		
		Map<Long,WaitHierarchyFacet> waithierarchyMap=waithierarchyList.stream().collect(Collectors.toMap(
                facet -> facet.getConceptId() != null ? facet.getConceptId() : facet.getId(),
				Function.identity()));
		

		for(WaitHierarchyFacet oneWaitHierarchyModel:waithierarchyList){
			WaitHierarchyFacet oneSupWaitHierarchyModel=waithierarchyMap.get(oneWaitHierarchyModel.getSuperiorId());
			compareOneConceptName(oneSupWaitHierarchyModel,oneWaitHierarchyModel,conceptMap);
			
			List<WaitHierarchyFacet> inferiorList=oneWaitHierarchyModel.getInferiorList();
			if(null!=inferiorList){
				for (int i = 0; i < inferiorList.size(); i++) {
					WaitHierarchyFacet oneInferiorWaitHierarchyModel=inferiorList.get(i);
					compareOneConceptName(oneWaitHierarchyModel,oneInferiorWaitHierarchyModel,conceptMap);
				}
			}
		}
	}
    



	/**
	 * 处理一个名称分析
	 * 新概念，设置新增状态1
	 * 自身改名，改名状态1, 父组分改名状态1，父组分编辑状态1
	 * @param oneWaitHierarchyModel
	 * @param conceptMap
	 */
	private void compareOneConceptName(
			WaitHierarchyFacet supWaitHierarchyModel,
			WaitHierarchyFacet oneWaitHierarchyModel,
			Map<Long, Concept> conceptMap){

		Long id=oneWaitHierarchyModel.getConceptId();
		Long waitId=oneWaitHierarchyModel.getWaitConceptId();
		
		if(1L==waitId){
			oneWaitHierarchyModel.setIsCreate(1);
		}else{
			if(oneWaitHierarchyModel.getEditName()!=-1){
				return;
			}
			
			Concept conceptDb=conceptMap.get(id);
			if(null!=conceptDb){
				if(!conceptDb.getName().equals(oneWaitHierarchyModel.getName())){
					//组分改名添加到内涵空间更新列表
					oneWaitHierarchyModel.setEditName(1);
					supWaitHierarchyModel.setRenameComp(1);
					supWaitHierarchyModel.setIsEditComp(1);
					
				    List<ConnotationDifference> connotationDifferenceList=supWaitHierarchyModel.getConnotationDifferenceList();
				    if(null==connotationDifferenceList){
				    	connotationDifferenceList=new ArrayList<>();
				    	supWaitHierarchyModel.setConnotationDifferenceList(connotationDifferenceList);
				    }
				    ConnotationDifference cm=new ConnotationDifference();
				    cm.setConceptId(oneWaitHierarchyModel.getConceptId());
				    cm.setUpdateType(4);
				    cm.setName(oneWaitHierarchyModel.getName());
				    connotationDifferenceList.add(cm);
				}
			}
		}
		
	}
	
	
    
    /**
     * 构造已有概念的新版本
     * @param articleList
     * @param allParagraphList
     * @param eventId
     * @param createTime
     * @param explorerId
     * @return
     */
    List<Edition> createNewEditionForExistConceptList(
    		List<Article> articleList,List<Paragraph> allParagraphList,
    		EditEvent event){
		 Long eventId=event.getId();
		 Long explorerId=event.getExplorerId();
		
    	List<Edition> editionList=new ArrayList<>();
    	
		//=============生成版本信息=============
		for (WaitHierarchyFacet oneWaitHierarchyModel:this) {
			List<WaitHierarchyFacet> inferiorList=oneWaitHierarchyModel.getInferiorList();
			if(1!=oneWaitHierarchyModel.getIsEditComp()){
				continue;
			}
			
			//准备版本信息
			Edition oneEditionModel=new Edition();
			editionList.add(oneEditionModel);
			Long editionId=StaticSnowflake.generateId(1, TableIdEnum.EDITION.getTableId());
			oneEditionModel.setId(editionId);
			oneEditionModel.setEventId(eventId);
			oneEditionModel.setCreateTime(new Date());
			oneEditionModel.setAuthorId(explorerId);
			oneEditionModel.setCheckStatus(0);
			oneEditionModel.setConceptId(oneWaitHierarchyModel.getConceptId());
			//oneEditionModel.setWaitConceptId(oneWaitHierarchyModel.getWaitConceptId());
			oneEditionModel.setConcept(oneWaitHierarchyModel.getName());
			oneEditionModel.setDigest("内涵空间更新");
			oneEditionModel.setConnotationDifferenceList(oneWaitHierarchyModel.getConnotationDifferenceList());
			
			
			List<Connotation> connotationList=new ArrayList<>();
			oneEditionModel.setConnotationList(connotationList);
			
			if(null!=inferiorList){
				for (int i = 0; i < inferiorList.size(); i++) {
					WaitHierarchyFacet oneInferiorWaitHierarchyModel=inferiorList.get(i);

					//内涵空间放入版本信息
					Connotation oneConnotationModel=new Connotation();
					oneConnotationModel.setId(oneInferiorWaitHierarchyModel.getConceptId());
					oneConnotationModel.setName(oneInferiorWaitHierarchyModel.getName());
					oneConnotationModel.setSequence(i);
					connotationList.add(oneConnotationModel);
				}
			}
		}
    	
    	
		List<Edition> list=editionList;
		//=================================添加版本信息时，加入当前版本的段落，中心和文献===========================================================
		
		Map<Long,Article> articleMap=ListMapper.getMapOfList(articleList);
		Map<Long,List<Paragraph>> paragraphMap=new HashMap<Long, List<Paragraph>>();
		allParagraphList=allParagraphList.stream().sorted(Comparator.comparingInt(Paragraph::getSequence)).collect(Collectors.toList());
		//段落列表关联到文章
		for (int i = 0; i < allParagraphList.size(); i++) {
			Paragraph oneParagraphModel=allParagraphList.get(i);
			Long conceptId=oneParagraphModel.getConceptId();
			List<Paragraph> oneArticleParagList=paragraphMap.get(conceptId);
			if(null==oneArticleParagList) {
				oneArticleParagList=new ArrayList<Paragraph>();
				paragraphMap.put(conceptId, oneArticleParagList);
			}
			oneArticleParagList.add(oneParagraphModel);
		}
		
		
		//文章列表接入版本列表

		for (int i = 0; i < list.size(); i++) {
			Edition oneEditionModel=list.get(i);
			Long conceptId=oneEditionModel.getConceptId();
			if(null!=conceptId && 0<conceptId){
				Article oneArticleModel=articleMap.get(conceptId);
				if(null!=oneArticleModel){
					oneEditionModel.setCentralIdea(oneArticleModel.getCentralIdea());
					oneEditionModel.setReference(oneArticleModel.getReference());
					oneEditionModel.setParagraphList(paragraphMap.get(conceptId)); 
				}
			}
		}
    	return editionList;
    }
    
	
	
    /**
     * 分析查询条件：当前视野内的所有节点的上级直属节点
     * @param thisAndFristHierarchyList
     * @param partIdList
     * @return
     */
	List<HierarchySuperiorListOnPartCondition> superiorIdListOnPartConditionList(){
		List<WaitHierarchyFacet> thisAndFristHierarchyList=this;
    	List<Long> partIdList=thisAndFristHierarchyList.get(0).getSuperiorIdList();
    	
    	List<HierarchySuperiorListOnPartCondition> superiorIdListOnPartConditionList=new ArrayList<>();

		for (WaitHierarchyFacet oneWaitHierarchyModel:thisAndFristHierarchyList) {
			List<Long> superiorIdList=oneWaitHierarchyModel.getSuperiorIdList();
			
			List<WaitHierarchyFacet> inferiorList=oneWaitHierarchyModel.getInferiorList();
			if(null!=inferiorList){
				for (int i = 0; i < inferiorList.size(); i++) {
					WaitHierarchyFacet oneInferiorWaitHierarchyModel=inferiorList.get(i);
					Long inConceptId=oneInferiorWaitHierarchyModel.getConceptId();
					if(null==inConceptId) {
						inConceptId=oneInferiorWaitHierarchyModel.getId();
					}
					
					//这里的层级算法应该取没编辑之前的结构
					List<Long> editingSuperiorIdListTwo=new ArrayList<Long>();
					if(null!=superiorIdList && superiorIdList.size()>0) {
						editingSuperiorIdListTwo=DeepClone.deepClone(superiorIdList);
						editingSuperiorIdListTwo.add(inConceptId);
					}
					HierarchySuperiorListOnPartCondition hierarchySuperiorListOnPartCondition=new HierarchySuperiorListOnPartCondition(inConceptId, partIdList,editingSuperiorIdListTwo);
					superiorIdListOnPartConditionList.add(hierarchySuperiorListOnPartCondition);
				}
			}
		}
		return superiorIdListOnPartConditionList;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
    
    
    
}
