package xyz.zhiwei.article.morphism.appearance.hierarchy.request;

import java.util.ArrayList;
import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.base.model.LifePrinciple;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;

class WaitHierarchyFacet extends LifePrinciple<Long>{

	private static final long serialVersionUID = -4190436134945979590L;

	private Long eventId;

    private Integer checkStatus;

    private Long superiorId;

    private Long conceptId;
    
    //新增节点时，节点入库后将获取自增ID, 无法再依据ID区分 是否新增。
    private Long waitConceptId=0L;//已有概念=0；纯新增概念=1


    private Integer sequence;

    private Integer showEditLevel;
    
    private Integer isCreate=0;
    
    private Integer editName=0;

    
    private Integer isEditComp=0;
    
    private Integer addComp=0;

    private Integer delComp=0;

    private Integer orderComp=0;
    
    private Integer renameComp=0;

	private List<Long> superiorIdList;
	
	private List<WaitHierarchyFacet> inferiorList;
	
    private List<ConnotationDifference> connotationDifferenceList;

    
    
    WaitHierarchyFacet() {};
    

    WaitHierarchyFacet(HierarchyRequestInit init) {
    	this.id=init.getId();
    	this.name=init.getName();
    	this.sequence=init.getSequence();
    	this.superiorId=init.getSuperiorId();
    	this.superiorIdList=init.getSuperiorIdList();
    	this.showEditLevel=init.getShowEditLevel();
    	if(null!=init.getInferiorList()) {
    		inferiorList=new ArrayList<WaitHierarchyFacet>();
    		for(HierarchyRequestInit initInferior:init.getInferiorList()) {
    			inferiorList.add(new WaitHierarchyFacet(initInferior));
    		}
    	}
    }
    

    Hierarchy toHierarchy() {
    	Hierarchy hierarchy=new Hierarchy(this.getId());
    	hierarchy.setName(this.getName());
    	return hierarchy;
    }
    
    
	Long getEventId() {
		return eventId;
	}

	void setEventId(Long eventId) {
		this.eventId = eventId;
	}

	Integer getCheckStatus() {
		return checkStatus;
	}

	void setCheckStatus(Integer checkStatus) {
		this.checkStatus = checkStatus;
	}

	Long getSuperiorId() {
		return superiorId;
	}

	void setSuperiorId(Long superiorId) {
		this.superiorId = superiorId;
	}

	Long getConceptId() {
		if(null!=conceptId) {
			return conceptId;
		}else {
			return id;
		}
	}

	void setConceptId(Long conceptId) {
		this.conceptId = conceptId;
	}

	Long getWaitConceptId() {
		return waitConceptId;
	}

	void setWaitConceptId(Long waitConceptId) {
		this.waitConceptId = waitConceptId;
	}

	Integer getSequence() {
		return sequence;
	}

	void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	Integer getShowEditLevel() {
		return showEditLevel;
	}

	void setShowEditLevel(Integer showEditLevel) {
		this.showEditLevel = showEditLevel;
	}

	Integer getIsCreate() {
		return isCreate;
	}

	void setIsCreate(Integer isCreate) {
		this.isCreate = isCreate;
	}

	Integer getEditName() {
		return editName;
	}

	void setEditName(Integer editName) {
		this.editName = editName;
	}

	Integer getIsEditComp() {
		return isEditComp;
	}

	void setIsEditComp(Integer isEditComp) {
		this.isEditComp = isEditComp;
	}

	Integer getAddComp() {
		return addComp;
	}

	void setAddComp(Integer addComp) {
		this.addComp = addComp;
	}

	Integer getDelComp() {
		return delComp;
	}

	void setDelComp(Integer delComp) {
		this.delComp = delComp;
	}

	Integer getOrderComp() {
		return orderComp;
	}

	void setOrderComp(Integer orderComp) {
		this.orderComp = orderComp;
	}

	Integer getRenameComp() {
		return renameComp;
	}

	void setRenameComp(Integer renameComp) {
		this.renameComp = renameComp;
	}

	List<WaitHierarchyFacet> getInferiorList() {
		return inferiorList;
	}

	void setInferiorList(List<WaitHierarchyFacet> inferiorList) {
		this.inferiorList = inferiorList;
	}

	List<Long> getSuperiorIdList() {
		return superiorIdList;
	}

	void setSuperiorIdList(List<Long> superiorIdList) {
		this.superiorIdList = superiorIdList;
	}

	List<ConnotationDifference> getConnotationDifferenceList() {
		return connotationDifferenceList;
	}

	void setConnotationDifferenceList(List<ConnotationDifference> connotationDifferenceList) {
		this.connotationDifferenceList = connotationDifferenceList;
	}

	

}