package xyz.zhiwei.article.morphism.appearance.hierarchy.request;

import java.util.List;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 
 */
class Source extends SessionSource{
	
	
	/**
	 * List<PrincipleSource>
	 * 0: [List<Session>,已有ID的当前节点和下一级节点的下级总表] 
	 * 0: [List<Session>,List<Hierarchy>  ] 
	 * 1: [关联到的概念列表，对应的文章列表，关联到的段落列表,   直属上级列表,   用户的贡献值列表]
	 * 1: [List<Concept>，  List<Article>， List<Paragraph>,  List<Hierarchy>,List<Contribution>]
	 */
	//private List<PrincipleSource> principleSourceList;
	
	
	Source(List<PrincipleSource> principleSourceList) {
		super(principleSourceList);
	}


	
	/**
	 * 关联概念的下级总表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Hierarchy> getThisAndOneSubHierarchyAllList() {
		@SuppressWarnings("unchecked")
		List<Hierarchy> list=(List<Hierarchy>) this.principleSourceList.getFirst().get(1);
	    return list;
	}
	
	
	
	/**
	 * 关联到的概念列表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Concept> getReConceptList() {
		@SuppressWarnings("unchecked")
		List<Concept> list=(List<Concept>) this.principleSourceList.get(1).getFirst();
	    return list;
	}
	

	/**
	 * 关联到的文章列表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Article> getReArticleList() {
		@SuppressWarnings("unchecked")
		List<Article> list=(List<Article>) this.principleSourceList.get(1).get(1);
	    return list;
	}
	
	/**
	 * 关联到的段落列表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Paragraph> getReParagraphList() {
		@SuppressWarnings("unchecked")
		List<Paragraph> list=(List<Paragraph>) this.principleSourceList.get(1).get(2);
	    return list;
	}
	
	
	/**
	 * 二级节点的直属上级列表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Hierarchy> getDirSupHierarchyList() {
		@SuppressWarnings("unchecked")
		List<Hierarchy> list=(List<Hierarchy>) this.principleSourceList.get(1).get(3);
	    return list;
	}
	

	/**
	 * 用户的贡献列表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Contribution> getContributionList() {
		@SuppressWarnings("unchecked")
		List<Contribution> list=(List<Contribution>) this.principleSourceList.get(1).get(4);
	    return list;
	}
}
