package xyz.zhiwei.article.morphism.appearance.hierarchy.request;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.article.qualify.ArticleQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ParagraphQualify;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 限定符生成器
 */
class Qualify {

	
    /**
     * 版本列表的文章信息
     * @param hierarchyList
     * @return
     */
    static PrincipleQualifier<Article> articleList(List<Hierarchy> hierarchyList){
		List<Article> articleSimilarList=hierarchyList.stream().map(hierarchy -> new Article(hierarchy.getConceptId())).collect(Collectors.toList());
		return ArticleQualify.PQ.pkList(articleSimilarList);
    }
	

    /**
     * 版本列表的段落信息
     * @param existHierarchyList
     * @return
     */
    static PrincipleQualifier<Paragraph> paragraphList(List<Hierarchy> hierarchyList){
		List<Paragraph> articleParagraphSimilarList=hierarchyList.stream().map(hierarchy -> new Paragraph(null,hierarchy.getConceptId())).collect(Collectors.toList());
		return ParagraphQualify.PQ.fkList(articleParagraphSimilarList);
    }
	
}
