package xyz.zhiwei.article.morphism.appearance.hierarchy.request;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.article.morphism.principle.article.imagine.ConceptImagine;
import xyz.zhiwei.article.morphism.principle.article.imagine.ContributionImagine;
import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.article.qualifier.HierarchySuperiorListOnPartQualifier;
import xyz.zhiwei.article.morphism.principle.article.qualify.ConceptQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.article.morphism.principle.edition.model.EditEvent;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.image.TransactionGroupList;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 层级更新申请
 */
public class HierarchyRequestAppearance extends SessionAppearance{


	//init
    private HierarchyRequestInit init;

    //=============原象=============
    private Source source;
    //已有ID的当前节点和下一级节点的下级总表
    private List<Hierarchy> subHierarchyList;
    //到下级节点的概念列表,文章列表，段落列表
    private List<Concept> reConceptList;
    private List<Article> reArticleList;
    private List<Paragraph> reParagraphList;
    //二级层级的直属上级列表
    private List<Hierarchy> dirSupHierarchyList;
    //当前用户的贡献值列表
    private List<Contribution> userContributionList;

    
    //=============构造=============
    //事件标识
    private EditEvent event;
    //解层级
    private WaitHierarchyListFacet waitHierarchyListFacet;
    
    //=============变换=============
    //分析概念统计数
    private ConceptUpdateCountForHierarchyRequestFacet conceptUpdateCountForHierarchyRequestFacet;
    
    
    //=============映象=============
    //新增事件标识
    private EditEvent newEditEventModel;
    //概念生成版本
    private List<Edition> newConnotationEditionList;
    
    //概念统计数更新列表
    private List<Concept> updateConceptStatsList;
    //贡献统计数新增列表
    private List<Contribution> newContributionStatsList;
    //贡献统计数更新列表
    private List<Contribution> updateContributionStatsList;
    
    

    //=============事务集=============

    //新增事件标识
    private List<EditEvent> newEditEventModelTL;
    //概念生成版本
    private List<Edition> newConnotationEditionListTL;
    
    //概念统计数更新列表
    private List<Concept> updateConceptStatsListTL;
    //贡献统计数新增列表
    private List<Contribution> newContributionStatsListTL;
    //贡献统计数更新列表
    private List<Contribution> updateContributionStatsListTL;
    
    
    
    
    //初始化
	public HierarchyRequestAppearance(String token,HierarchyRequestInit init) {
		super(token);
		this.init=init;
	}
	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);

	    //解层级
	    this.waitHierarchyListFacet=new WaitHierarchyListFacet(this.init);
    	//每个概念的直属下级列表
    	PrincipleQualifier<Hierarchy> subHierarchyQualifier=HierarchyQualify.PQ.subHierarchyQualifier(this.waitHierarchyListFacet.getExistHierarchyList());
    	
		return principleQualifiers.addOne(subHierarchyQualifier);
	};

    
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询
	 * @param relatedCollectionList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
    	this.source=new Source(principleSourceList);
    	
    	//每个概念的直属下级列表
		this.subHierarchyList=this.source.getThisAndOneSubHierarchyAllList();

		//已有ID的当前节点和下一级节点, 以及这些节点的数据库下级节点的概念信息
    	PrincipleQualifier<Concept> conceptListQualifier=ConceptQualify.PQ.hierarchyList(this.waitHierarchyListFacet.getExistHierarchyListWithSubHierarchy(this.subHierarchyList));

		//版本列表的文章信息
		PrincipleQualifier<Article> articleListQualifier=Qualify.articleList(this.waitHierarchyListFacet.getExistHierarchyList());

		//版本列表的段落信息
		PrincipleQualifier<Paragraph> paragraphListQualifier=Qualify.paragraphList(this.waitHierarchyListFacet.getExistHierarchyList());

		//涉及概念的直属上级列表
		HierarchySuperiorListOnPartQualifier hierarchySuperiorListOnPartQualifier=HierarchyQualify.PQ.hierarchySuperiorListOnPartQualifier(this.waitHierarchyListFacet.superiorIdListOnPartConditionList());

        //用户的贡献值列表
		PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.explorerId(this.loginUser.getId());
		
		return new PrincipleQualifiers(conceptListQualifier,articleListQualifier,paragraphListQualifier,hierarchySuperiorListOnPartQualifier,contributionQualifier);
	};
	


	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.reConceptList=this.source.getReConceptList();
		this.reArticleList=this.source.getReArticleList();
		this.reParagraphList=this.source.getReParagraphList();
		this.dirSupHierarchyList=this.source.getDirSupHierarchyList();
		this.userContributionList=this.source.getContributionList();
		
        //事件标识
		this.event=new EditEvent(this.loginUser.getId());

		//更新概念差异：[新增; 编辑：添加组分,删除组分,重排组分]
		this.waitHierarchyListFacet.updateCompareComponent(this.subHierarchyList, this.reConceptList);
		
		//更新概念差异：[重名组分]
		this.waitHierarchyListFacet.updateCompareConceptName(this.reConceptList);

	    
        return this;
	};
	

	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
	    //分析概念统计数
	    this.conceptUpdateCountForHierarchyRequestFacet=new ConceptUpdateCountForHierarchyRequestFacet(this.waitHierarchyListFacet, this.dirSupHierarchyList);
		
		return this;
	}

	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

	    //新增事件标识
	    this.newEditEventModel=this.event;
	    //概念生成版本（有组分更新的）
	    this.newConnotationEditionList=this.waitHierarchyListFacet.createNewEditionForExistConceptList(this.reArticleList, this.reParagraphList, this.event);
	    
	    //概念统计数更新列表
	    this.updateConceptStatsList=this.conceptUpdateCountForHierarchyRequestFacet.getUpdateCountToConceptList();

	    //贡献统计数新增列表
	    this.newContributionStatsList=this.conceptUpdateCountForHierarchyRequestFacet.getNewCountToContributionList(this.loginUser.getId(), this.userContributionList);
	    //贡献统计数更新列表
	    this.updateContributionStatsList=this.conceptUpdateCountForHierarchyRequestFacet.getUpdateCountToContributionList(this.loginUser.getId(), this.userContributionList);
	    

	    
		//==================组成返回值==================

	    this.newEditEventModelTL=Arrays.asList(this.newEditEventModel);
	    this.newConnotationEditionListTL=this.newConnotationEditionList;
	    this.updateConceptStatsListTL=ConceptImagine.updateInc(this.updateConceptStatsList);
	    this.newContributionStatsListTL=this.newContributionStatsList;
	    this.updateContributionStatsListTL=ContributionImagine.updateInc(this.updateContributionStatsList);
	    
	    
		List<List<? extends Principle<?>>> addition=List.of(
				newEditEventModelTL,
				newConnotationEditionListTL,
				newContributionStatsListTL);

		List<List<? extends Principle<?>>> modification=List.of(
				updateConceptStatsListTL,
				updateContributionStatsListTL);
		
		return new PrincipleImage(addition,modification);
	};
	
	
	/**
	 * 事务标识组
	 * @return
	 */
	@Override
	public TransactionGroupList transactionGroupList() {
		
		List<List<? extends Principle<?>>> groupA=Arrays.asList(
				newEditEventModelTL,
				newConnotationEditionListTL,
				newContributionStatsListTL,
				updateConceptStatsListTL,
				updateContributionStatsListTL);

		return new TransactionGroupList(groupA);
	}; 
	
	
}




































