package xyz.zhiwei.article.morphism.appearance.hierarchy.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountCombineListFacet;
import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;

/**
 * 生成层级编辑请求数: 
 */
public class ConceptUpdateCountForHierarchyRequestFacet {

	//当前层级编辑数
	private List<ConceptUpdateCountFacet> conceptUpdateCountList;

	//合并更新数
	private ConceptUpdateCountCombineListFacet conceptUpdateCountCombineList;
	
	
	ConceptUpdateCountForHierarchyRequestFacet(WaitHierarchyListFacet waitHierarchyListFacet,
			List<Hierarchy> superHierarchyList) {
		
		this.conceptUpdateCountList=conceptUpdateCountList(waitHierarchyListFacet,superHierarchyList);

		this.conceptUpdateCountCombineList=new ConceptUpdateCountCombineListFacet(this.conceptUpdateCountList);
	}
	

    /**
     * 更新的统计数转概念列表
     * @param combineUpdateConutList
     * @return
     */
	List<Concept> getUpdateCountToConceptList() {
		return this.conceptUpdateCountCombineList.getUpdateCountToConceptList(ConceptUpdateCountFacet::requestToConcept);
	}
	
	
    /**
     * 更新统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getUpdateCountToContributionList(Long explorerId,List<Contribution> userContributionList) {
		return this.conceptUpdateCountCombineList.getUpdateCountToContributionList(
				explorerId,userContributionList,
				(oneUpdateCount, eId) -> oneUpdateCount.requestToContribution(eId));
	}
    
    /**
     * 新增统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getNewCountToContributionList(Long explorerId,List<Contribution> userContributionList) {
		return this.conceptUpdateCountCombineList.getNewCountToContributionList(
				explorerId,userContributionList,
				(oneUpdateCount, eId) -> oneUpdateCount.requestToContribution(eId));
	}
	
	
	
	
	
	
	/**
	 * 分析出待审核的 新增，编辑 数
	 * 改名归入上级组分修改
	 * @param waitHierarchyModel
	 * @return
	 * 注意：此方法改变了下级列表概念的上级id列表
	 */
	private List<ConceptUpdateCountFacet> conceptUpdateCountList(WaitHierarchyListFacet waitHierarchyListFacet,
			List<Hierarchy> superHierarchyList){
		
		//概念按父级分组
		Map<Long,List<Long>> superHierarchyListMap=superHierarchyList.stream()
			    .collect(Collectors.groupingBy(Hierarchy::getSuperiorId, 
			        Collectors.mapping(Hierarchy::getConceptId,Collectors.toList()) ));
		
		
		
		Map<Long,ConceptUpdateCountFacet> updateCountMap=new HashMap<Long,ConceptUpdateCountFacet>();

		for (WaitHierarchyFacet oneWaitHierarchyModel:waitHierarchyListFacet) {
			Long conceptId=oneWaitHierarchyModel.getConceptId();
			List<Long> superiorIdList=oneWaitHierarchyModel.getSuperiorIdList();
			
			if(!updateCountMap.containsKey(conceptId) && (1==oneWaitHierarchyModel.getIsCreate()|| 1==oneWaitHierarchyModel.getIsEditComp())){
				ConceptUpdateCountFacet thisUpdateCount=new ConceptUpdateCountFacet();
				thisUpdateCount.setSuperiorIdList(superiorIdList);
				updateCountMap.put(conceptId,thisUpdateCount);
				updateConceptCount(thisUpdateCount,oneWaitHierarchyModel);
			}
			
			List<WaitHierarchyFacet> inferiorList=oneWaitHierarchyModel.getInferiorList();
			if(null!=inferiorList){
				for (int i = 0; i < inferiorList.size(); i++) {
					WaitHierarchyFacet oneInferiorWaitHierarchyModel=inferiorList.get(i);
					Long inConceptId=oneInferiorWaitHierarchyModel.getConceptId();
					
					//这里的层级算法应该取没编辑之前的结构
//					List<Long> editingSuperiorIdListTwo=DeepClone.deepClone(superiorIdList);
//					editingSuperiorIdListTwo.add(inConceptId);
					List<Long> superiorIdListTwo=superHierarchyListMap.get(inConceptId);
					//修改了原入参的值
					oneInferiorWaitHierarchyModel.setSuperiorIdList(superiorIdListTwo);
					
					if(!updateCountMap.containsKey(inConceptId) && (1==oneInferiorWaitHierarchyModel.getIsCreate()|| 1==oneInferiorWaitHierarchyModel.getIsEditComp())){
						ConceptUpdateCountFacet twoUpdateCount=new ConceptUpdateCountFacet();
						twoUpdateCount.setSuperiorIdList(superiorIdListTwo);
						updateCountMap.put(inConceptId,twoUpdateCount);
						updateConceptCount(twoUpdateCount,oneInferiorWaitHierarchyModel);
					}
				}
			}
		}
		

		List<ConceptUpdateCountFacet> updateCountList=new ArrayList<ConceptUpdateCountFacet>();
		for (Long id:updateCountMap.keySet()) {
			updateCountList.add(updateCountMap.get(id));
		}

		return updateCountList;
	}
	
	/**
	 * 按标识设置概念统计数
	 * @param conceptCount
	 * @param hierarchyModel
	 */
	private void updateConceptCount(ConceptUpdateCountFacet conceptCount,WaitHierarchyFacet hierarchyModel) {
		if(1==hierarchyModel.getIsCreate()){
			conceptCount.setCountCreate(1);
			conceptCount.setIsCreate(1);
		}
		if(1==hierarchyModel.getIsEditComp()){
			conceptCount.setCountEditCompOrArt(1);
			conceptCount.setIsEditCompOrArt(1);
		}
	}
	
}
