package xyz.zhiwei.article.morphism.appearance.hierarchy.refuse;

import java.util.List;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 
 */
class Source extends SessionSource{
	
	/**
	 * List<PrincipleSource>
	 * 0: [登陆人       ,当前审核版本  ]
	 * 0: [List<Session>,List<Edition>]
	 * 
	 * 1.0: [当前版本概念的外延直属列表[currentId,....topId]]   
	 * 1.0: [List<Hierarchy>]
	 * 
	 * 
	 * 
	 * 
	 */
	//private List<PrincipleSource> principleSourceList;
	
	
	Source(List<PrincipleSource> principleSourceList) {
		super(principleSourceList);
	}

	/**
	 * 当前评审的版本
	 * @param principleSourceList
	 * @return
	 */
	Edition getThisEdition() {
		@SuppressWarnings("unchecked")
		List<Edition> list=(List<Edition>) this.principleSourceList.getFirst().get(1);
		return list.isEmpty() ? null : list.get(0);
	}
	

	/**
	 * 当前版本概念的外延直属列表[currentId,....topId]
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> getDirectlySuperiorHierarchy() {
	    return  (List<Hierarchy>) principleSourceList.get(1).getFirst();
	}

}
