package xyz.zhiwei.article.morphism.appearance.hierarchy.refuse;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.edition.qualify.EditionQualify;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.image.TransactionGroupList;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 版本审批拒绝
 */
public class HierarchyRefuseAppearance extends SessionAppearance{


	//init
    private EditionRefuseInit init;

    //=============原象=============
    private Source source;
    //当前评审版本
    private Edition thisEdition;
    //当前版本概念的外延直属列表[currentId,....topId]
    private List<Hierarchy> superiorHierarchyList;

    //=============构造=============
    //版本本身
    private EditionRefuseFacet editionRefuseFacet;
    
    //=============变换=============
    //统计数
    private ConceptUpdateCountForRefuseFacet updateCountCombineFacet;
    
    //=============映象=============
    //版本拒绝
    private Edition refuseEdition;
    //当前的概念统计
    private List<Concept> conceptStatsList;
    //当前概念的贡献统计
    private List<Contribution> contributionStatsList;
    

    //=============事务集=============

    //版本拒绝
    private List<Edition> refuseEditionTL;
    //当前的概念统计
    private List<Concept> conceptStatsListTL;
    //当前概念的贡献统计
    private List<Contribution> contributionStatsListTL;

	//初始化
	public HierarchyRefuseAppearance(String token,EditionRefuseInit init) {
		super(token);
		this.init=init;
	}


    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	
    	//当前审核的概念版本
    	PrincipleQualifier<Edition> editionQualifier=EditionQualify.PQ.pk(this.init.getId());

		return principleQualifiers.addOne(editionQualifier);
	};
	

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询
	 * @param relatedCollectionList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
    	this.source=new Source(principleSourceList);
    	this.thisEdition=this.source.getThisEdition();

    	//当前版本概念的外延直属列表[currentId,....topId]
    	PrincipleQualifier<Hierarchy> directlySuperiorHierarchyQualifier=HierarchyQualify.PQ.directlySuperiorHierarchyQualifier(this.thisEdition.getConceptId());

    	return new PrincipleQualifiers(directlySuperiorHierarchyQualifier);
    	
    }
	
	
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.superiorHierarchyList=this.source.getDirectlySuperiorHierarchy();

		//版本本身
	    this.editionRefuseFacet=new EditionRefuseFacet(this.thisEdition);
		
        return this;
	}

	
	
	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
		//版本拒绝
		this.editionRefuseFacet.refuse(this.loginUser.getId(), this.init);

		//统计数
		this.updateCountCombineFacet=new ConceptUpdateCountForRefuseFacet(this.superiorHierarchyList);
		
		return this;
	}
	

	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

	    //版本拒绝
	    this.refuseEdition=this.editionRefuseFacet;
		//概念更新数
		this.conceptStatsList=this.updateCountCombineFacet.getUpdateCountToConceptList();
	    //当前概念的贡献统计
	    this.contributionStatsList=this.updateCountCombineFacet.getUpdateCountToContributionList(this.thisEdition.getAuthorId());
		

		//==================组成返回值==================
	    this.refuseEditionTL=List.of(refuseEdition);
	    this.conceptStatsListTL=this.conceptStatsList;
	    this.contributionStatsListTL=this.contributionStatsList;
	    
		List<List<? extends Principle<?>>> modification=List.of(
				this.refuseEditionTL,
				this.conceptStatsListTL,
				this.contributionStatsListTL
				);

		return new PrincipleImage(null,modification);
	}
	

	/**
	 * 事务标识组
	 * @return
	 */
	@Override
	public TransactionGroupList transactionGroupList() {
		
		List<List<? extends Principle<?>>> groupA=Arrays.asList(
				this.refuseEditionTL,
				this.conceptStatsListTL,
				this.contributionStatsListTL
				);

		return new TransactionGroupList(groupA);
	}; 
}
