package xyz.zhiwei.article.morphism.appearance.hierarchy.refuse;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountCombineListFacet;
import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.support.util.DeepClone;

/**
 * 版本拒绝时的概念统计数
 */
class ConceptUpdateCountForRefuseFacet{


	//当前概念编辑数
	private ConceptUpdateCountFacet thisConceptUpdateCount;

	//合并更新数
	private ConceptUpdateCountCombineListFacet conceptUpdateCountCombineList;
	
	
	
	
	ConceptUpdateCountForRefuseFacet(List<Hierarchy> superiorHierarchyList) {
		
		List<Long> superiorIdList=superiorHierarchyList.stream()
			    .map(concept -> concept.getConceptId())
			    .collect(Collectors.toList())
			    .reversed();
		
		this.thisConceptUpdateCount=new ConceptUpdateCountFacet(DeepClone.deepClone(superiorIdList));
		this.thisConceptUpdateCount.setCountEditCompOrArt(1);
		this.thisConceptUpdateCount.setIsEditCompOrArt(1);
		

		this.conceptUpdateCountCombineList=new ConceptUpdateCountCombineListFacet(thisConceptUpdateCount);
		
		
	}
	
	
	

    /**
     * 更新的统计数转概念列表
     * @param combineUpdateConutList
     * @return
     */
	List<Concept> getUpdateCountToConceptList() {
		return this.conceptUpdateCountCombineList.getUpdateCountToConceptList(ConceptUpdateCountFacet::refuseToConcept);
	}
	

    /**
     * 更新统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getUpdateCountToContributionList(Long explorerId) {
		return this.conceptUpdateCountCombineList.getUpdateContributionList(explorerId,(oneUpdateCount, eId) -> oneUpdateCount.refuseToContribution(eId));
	}
    
}
