package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.List;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 
 */
class Source extends SessionSource{
	
	
	/**
	 * List<PrincipleSource>
	 * 0: [登陆人       ,当前审核版本  ]
	 * 0: [List<Session>,List<Edition>]
	 * 
	 * 1.0: [同一编辑事件的版本列表]   
	 * 1.0: [List<Edition>]
	 * 
	 * 
	 * 2.0: [当前版本的移动而新增的组分的上级节点列表]   
	 * 2.0: [ List<Hierarchy>]
	 * 
	 * 
	 * 3.0-3: [上一版本,      用户在此概念上的所有通过版本,用户所有的贡献值列表,  当前版本概念的外延直属列表[currentId,....topId]]   
	 * 3.0-3: [List<Edition>, List<Edition>,             List<Contribution>， List<Hierarchy>                                ]
	 * 
	 * 3.4-6: [ 作为组分移动的概念列表,作为组分移动的贡献列表,要清除的当前段落列表]   
	 * 3.4-6: [List<Concept>,        List<Contribution>   ，List<Paragraph>]
	 * 
	 * 
	 */
	//private List<PrincipleSource> principleSourceList;
	
	
	Source(List<PrincipleSource> principleSourceList) {
		super(principleSourceList);
	}

	/**
	 * 当前评审的版本
	 * @param principleSourceList
	 * @return
	 */
	Edition getThisEdition() {
		@SuppressWarnings("unchecked")
		List<Edition> list=(List<Edition>) this.principleSourceList.getFirst().get(1);
		return list.isEmpty() ? null : list.get(0);
	}
	

	/**
	 * 同一编辑事件的版本列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Edition> getSameEventEditionList() {
	    return  (List<Edition>) principleSourceList.get(1).getFirst();
	}


	/**
	 * 当前版本的移动而新增的组分的上级节点列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> getDirectlySuperiorHierarchyList() {
	    return  (List<Hierarchy>) principleSourceList.get(2).getFirst();
	}
	
	/**
	 * 上一版本
	 * @param principleSourceList
	 * @return
	 */
	Edition getLastEdition() {
		@SuppressWarnings("unchecked")
		List<Edition> list=(List<Edition>) this.principleSourceList.get(3).getFirst();
		return list.isEmpty() ? null : list.get(0);
	}
	

	/**
	 * 用户此概念上的所有审核版本
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Edition> getExplorerConceptEditionList() {
	    return  (List<Edition>) principleSourceList.get(3).get(1);
	}
	
	/**
	 * 用户的贡献列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Contribution> userContributionList(){
	    return (List<Contribution>) principleSourceList.get(3).get(2); 
	}
	

	/**
	 * 当前版本概念的外延直属列表[currentId,....topId]
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> getDirectlySuperiorHierarchy() {
	    return  (List<Hierarchy>) principleSourceList.get(3).get(3);
	}
	

	
	/**
	 * 组分移动的概念列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Concept> getComUpdateConceptList(){
	    return (List<Concept>) principleSourceList.get(3).get(4); 
	}
	
	
	/**
	 * 组分移动的贡献列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Contribution> getComUpdateContributionList(){
	    return (List<Contribution>) principleSourceList.get(3).get(5); 
	}
	
	/**
	 * 当前节点的段落列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Paragraph> getExistParagraphList(){
	    return (List<Paragraph>) principleSourceList.get(3).get(6); 
	}
}
