package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualify.ArticleQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ConceptQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 限定符生成器
 */
class Qualify {

	
    /**
     * 版本列表的文章信息
     * @param hierarchyList
     * @return
     */
    static PrincipleQualifier<Article> articleList(List<Hierarchy> hierarchyList){
		List<Article> articleSimilarList=hierarchyList.stream().map(hierarchy -> new Article(hierarchy.getConceptId())).collect(Collectors.toList());
		return ArticleQualify.PQ.pkList(articleSimilarList);
    }
	

	/**
	 * 概念列表
	 * @return
	 */
    static PrincipleQualifier<Concept> conceptList(List<ConnotationDifference> connotationList){
		List<Concept> conceptList=connotationList.stream().map(c-> new Concept(c.getConceptId())).collect(Collectors.toList());
		return ConceptQualify.PQ.pkList(conceptList);
	}
	

	/**
	 * 子集限定符：外延直属列表
	 * 
	 * 查找这个概念被移除出的父节点，这个父节点可能已经被删除，所以没有生成待审核版本。
	 * 一直找到一个父节点，这个父节点是有版本待审核的。
	 * @return
	 */
    static PrincipleQualifier<Hierarchy> directlySuperiorHierarchyListQualifier(List<ConnotationDifference> connotationDifferenceList){
		List<Hierarchy> hierarchyList=connotationDifferenceList.stream().map(c-> new Hierarchy(c.getConceptId())).collect(Collectors.toList());
		return HierarchyQualify.PQ.directlySuperiorHierarchyListQualifier(hierarchyList);
	}
	

	/**
	 * 子集限定符：概念列表相关的贡献列表
	 * @return
	 */
    static PrincipleQualifier<Contribution> contributionList(List<ConnotationDifference> connotationList){
		List<Contribution> contributionList=connotationList.stream().map(
				c-> { 
					Contribution cb=new Contribution();
					cb.setConceptId(c.getConceptId());
					return cb;
					}
				).collect(Collectors.toList());

		return ContributionQualify.PQ.fkList(contributionList);
	}
	
}
