package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

/**
 * 新增组分的版本列表
 */
class NewConceptsToEditionListFacet {

    //新版本列表
    private List<Edition> editionList; 
    //新层级列表
    private List<Hierarchy> hierarchyList;
    //新概念列表
    private List<Concept> conceptList;
    //新文章列表
    private List<Article> articleList;
    //新贡献值列表
	private List<Contribution> contributionList;
	
	
	/**
	 * 新增的内涵组分转版本
	 */
	NewConceptsToEditionListFacet(Edition edition,List<Hierarchy> newHierarchyList) {

		
		//新增的版本
		List<Edition> editionList=new ArrayList<>();
		for (Hierarchy hierarchy : newHierarchyList) {

			Edition fristEdition=new Edition();
			
			Long editionId=StaticSnowflake.generateId(1, TableIdEnum.EDITION.getTableId());
			fristEdition.setId(editionId);
			
			fristEdition.setEventId(edition.getEventId());
			fristEdition.setConceptId(hierarchy.getConceptId());
			fristEdition.setConcept(hierarchy.getName());
			fristEdition.setDigest("创建节点");
			fristEdition.setAuthorId(edition.getAuthorId());
			fristEdition.setCreateTime(edition.getCreateTime());

			fristEdition.setEdition(1);
			fristEdition.setGraderId(edition.getGraderId());
			fristEdition.setGrade(edition.getGrade());
			fristEdition.setContribution(edition.getContribution());
			fristEdition.setCheckStatus(1);
			fristEdition.setCheckTime(new Date());
			
			editionList.add(fristEdition);
		}
		this.editionList=editionList;
		
		
		//需要新增的层级列表
		this.hierarchyList=newHierarchyList;
		
		//需要新增概念列表
		this.conceptList=newHierarchyList.stream()
				.map(h -> {
	                Concept addConceptModel = new Concept(h.getConceptId(), h.getName());
					//addConceptModel.setUseType(1);
					addConceptModel.setCreateTime(edition.getCreateTime());
					return addConceptModel;
				})
				.collect(Collectors.toList());
		
		//需要新增的文章列表
		this.articleList = this.editionList.stream()
			    .map(editionModel -> {
			        Article addArticleModel = new Article();
			        addArticleModel.setId(editionModel.getConceptId());
			        addArticleModel.setLastAuthorId(editionModel.getAuthorId());
			        addArticleModel.setCreateTime(editionModel.getCreateTime());
			        addArticleModel.setEditionId(editionModel.getId());
			        addArticleModel.setEsSync(0);
			        return addArticleModel;
			    })
			    .collect(Collectors.toList());
		
		//需要新增的贡献值列表
		this.contributionList = this.editionList.stream()
			    .map(editionModel -> {
			        Contribution newContributionModel = new Contribution();
					Long contributionId=StaticSnowflake.generateId(1, TableIdEnum.CONTRIBUTION.getTableId());
					newContributionModel.setId(contributionId);
			        newContributionModel.setConceptId(editionModel.getConceptId());
			        newContributionModel.setExplorerId(editionModel.getAuthorId());
			        newContributionModel.setGrade(editionModel.getGrade());
			        newContributionModel.setContribution(editionModel.getContribution());
			        return newContributionModel;
			    })
			    .collect(Collectors.toList());
		
	}

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	List<Edition> getEditionList() {
		return editionList;
	}

	List<Hierarchy> getHierarchyList() {
		return hierarchyList;
	}

	List<Concept> getConceptList() {
		return conceptList;
	}

	List<Article> getArticleList() {
		return articleList;
	}

	List<Contribution> getContributionList() {
		return contributionList;
	}
	
	
}
