package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.ArrayList;
import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.edition.model.base.Connotation;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;


/**
 * 更新的内涵组分
 */
class HierarchyUpdateGroupFacet {


	private List<Hierarchy> addHierarchyList=new ArrayList<>();
	
	private List<Hierarchy> moveAddHierarchyList=new ArrayList<>();
	private List<Hierarchy> delHierarchyList=new ArrayList<>();
	private List<Hierarchy> moveDelHierarchyList=new ArrayList<>();
	private List<Hierarchy> reOrdelHierarchyList=new ArrayList<>();

	private List<Concept> delConceptList=new ArrayList<>();
	private List<Concept> renameConceptList=new ArrayList<>();

	private Boolean isReOrder=false;
	
	//private List<EditionWithSupId> addEditionList=new ArrayList<>();
	/**
	 * 
	 * 内涵组分更新分析
	 * @param editionModel
	 * @param connotationDifferenceGroup
	 */
	HierarchyUpdateGroupFacet(ConnotationDifferenceGroupFacet connotationDifferenceGroup) {
		Edition editionModel=connotationDifferenceGroup.getThisEdition();
		Long editionConcetpId=editionModel.getConceptId();

		List<ConnotationDifference> addList=connotationDifferenceGroup.getAddList();
		List<ConnotationDifference> moveAddList=connotationDifferenceGroup.getMoveAddList();
		List<ConnotationDifference> delList=connotationDifferenceGroup.getDelList();
		List<ConnotationDifference> moveDelList=connotationDifferenceGroup.getMoveDelList();
		List<ConnotationDifference> renameList=connotationDifferenceGroup.getRenameList();
		
		
		//===================新建处理===================
		for (int i = 0; i < addList.size(); i++) {
			ConnotationDifference addConnotationDifference=addList.get(i);
			
			Hierarchy addHierarchy=new Hierarchy();
			addHierarchy.setSuperiorId(editionConcetpId);
			addHierarchy.setConceptId(addConnotationDifference.getConceptId());
			addHierarchy.setName(addConnotationDifference.getName());
			addHierarchy.setSequence(0);
			this.addHierarchyList.add(addHierarchy);
			this.isReOrder=true;
		}
		

		//===================移动新增处理===================
		for (int i = 0; i < moveAddList.size(); i++) {
			ConnotationDifference moveAddConnotationDifference=moveAddList.get(i);
			
			Hierarchy moveAddHierarchy=new Hierarchy();
			moveAddHierarchy.setSuperiorId(editionConcetpId);
			moveAddHierarchy.setConceptId(moveAddConnotationDifference.getConceptId());
			moveAddHierarchy.setSequence(0);
			this.moveAddHierarchyList.add(moveAddHierarchy);
			this.isReOrder=true;
		}
		
		
		//===================删除处理===================
		for (int i = 0; i < delList.size(); i++) {
			ConnotationDifference delConnotationDifference=delList.get(i);
			
			Concept delConcept=new Concept();
			delConcept.setId(delConnotationDifference.getConceptId());
			//delConcept.setUseType(2);
			this.delConceptList.add(delConcept);
			
			Hierarchy delHierarchy=new Hierarchy();
			delHierarchy.setSuperiorId(editionConcetpId);
			delHierarchy.setConceptId(delConnotationDifference.getConceptId());
			this.delHierarchyList.add(delHierarchy);
			this.isReOrder=true;
		}
		
		//===================移除处理===================
		for (int i = 0; i < moveDelList.size(); i++) {
			ConnotationDifference moveDelConnotationDifference=moveDelList.get(i);
			
			Hierarchy moveDelHierarchy=new Hierarchy();
			moveDelHierarchy.setSuperiorId(editionConcetpId);
			moveDelHierarchy.setConceptId(moveDelConnotationDifference.getConceptId());
			this.moveDelHierarchyList.add(moveDelHierarchy);
			this.isReOrder=true;
		}
		
		
		//===================重命名处理===================
		for (int i = 0; i < renameList.size(); i++) {
			ConnotationDifference reConnotationDifference=renameList.get(i);
			Concept renameConcept=new Concept();
			renameConcept.setId(reConnotationDifference.getConceptId());
			renameConcept.setName(reConnotationDifference.getName());
			this.renameConceptList.add(renameConcept);
		}
		
		
		//===================重排处理===================
		if(this.isReOrder){
			List<Connotation> connotationList=editionModel.getConnotationList();
			for (int i = 0; i < connotationList.size(); i++) {
				Connotation oneConnotation=connotationList.get(i);
				Hierarchy oneReOrderHierarchy=new Hierarchy();
				oneReOrderHierarchy.setSuperiorId(editionConcetpId);
				oneReOrderHierarchy.setConceptId(oneConnotation.getId()); 
				oneReOrderHierarchy.setSequence(i);
				this.reOrdelHierarchyList.add(oneReOrderHierarchy);
			}
			
		}
		
		
	}

	
	
	Boolean getIsReOrder() {
		return isReOrder;
	}

	void setIsReOrder(Boolean isReOrder) {
		this.isReOrder = isReOrder;
	}



	List<Hierarchy> getAddHierarchyList() {
		return addHierarchyList;
	}



	List<Hierarchy> getMoveAddHierarchyList() {
		return moveAddHierarchyList;
	}



	List<Hierarchy> getDelHierarchyList() {
		return delHierarchyList;
	}



	List<Hierarchy> getMoveDelHierarchyList() {
		return moveDelHierarchyList;
	}



	List<Hierarchy> getReOrdelHierarchyList() {
		return reOrdelHierarchyList;
	}



	List<Concept> getDelConceptList() {
		return delConceptList;
	}



	List<Concept> getRenameConceptList() {
		return renameConceptList;
	}
	
	
		
		
}
