package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.article.morphism.principle.article.imagine.HierarchyImagine;
import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ParagraphQualify;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.edition.qualify.EditionQualify;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.support.exception.BusinessException;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.image.TransactionGroupList;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 版本审批通过
 */
public class HierarchyAcceptAppearance extends SessionAppearance{

	//init
    private EditionAcceptInit init;
	

    //=============原象=============
    private Source source;
    //当前评审版本
    private Edition thisEdition;
    //上一版本
    private Edition lastEdition;
    //同一编辑事件中的所有版本
    private List<Edition> sameEventEditionList;
    //当前版本的移动而新增的组分的上级节点列表
    private List<Hierarchy> directlySuperiorHierarchyList;
    //用户此概念上的所有审核版本
    private List<Edition> explorerConceptEditionList;
    //用户的贡献值列表
    private List<Contribution> userContributionList;
    //当前版本概念的外延直属列表[currentId,....topId]
    private List<Hierarchy> superiorHierarchyList;
    //作为组分移动的概念列表
    private List<Concept> comUpdateConceptList;
    //作为组分移动的贡献列表
    private List<Contribution> comUpdateContributionList;
    //要删除更新的段落列表
    private List<Paragraph> existParagraphList;
    
    //=============构造=============
    //当前版本的组分分类
    private ConnotationDifferenceGroupFacet connotationDifferenceGroupFacet;
    //因移入而新增的节点，需要找到移出节点的待评审节点
    private List<Hierarchy> supEditionHierarchyForMove;
    //更新的内涵组分
    private HierarchyUpdateGroupFacet hierarchyUpdateGroupFacet;
    //新增组分的版本列表
    private NewConceptsToEditionListFacet newConceptsToEditionListFacet;
    //版本本身
    private EditionAcceptFacet editionAcceptFacet;
    
    //=============变换=============
    //统计数：当前概念+新组分
    private ConceptCountForNewConceptsFacet conceptCountForNewConceptsFacet;
	//统计数： 组分移动的概念
    private ConceptCountForMoveConceptsFacet conceptCountForMoveConceptsFacet;
    
    //=============映象=============
    //移入的组分-新增
    private List<Hierarchy> moveAddHierarchyList;
    //删除的组分-递归删除
    private List<Hierarchy> delHierarchyList;
    //移除的组分-简单删除
    private List<Hierarchy> moveDelHierarchyList;
    //重排的组分-更新排序
    private List<Hierarchy> reOrderHierarchyList;
    
    //删除的组分-删除
    private List<Concept> delConceptList;
    //重命名的组分-更新
    private List<Concept> renameConceptList;
    
    //新增组分的首发版本
    private List<Edition> newConceptEditionList;
    //新增组分-新增
    private List<Hierarchy> newHierarchyList;
    //新增组分-新增概念
    //private List<Concept> newConceptAddList;
    //新增组分-新增文章
    private List<Article> newArticleList;
    //新增组分-新增贡献值
    //private List<Contribution> newConceptContributionList;
    
    //版本确认
    private Edition acceptEdition;
    //节点贡献值汇总
    private Contribution acceptContribution;
    //节点用户贡献值汇总
    private Explorer acceptExplorer;
    //节点更新的文章
    private Article acceptArticle;
    //节点先删除文章段落
    private List<Paragraph> delParagraphList;
    //节点新增文章的段落
    private List<Paragraph> articleParagraphList;

    //当前的概念统计
    private List<Concept> thisConceptStatsList;
    //新增组分的概念统计
    private List<Concept> newConceptStatsList;
    //当前概念的贡献统计
    private List<Contribution> thisContributionStatsList;
    //新增组分的贡献统计
    private List<Contribution> newContributionStatsList;

    //移动组分的概念统计
    private List<Concept> moveConceptStatsList;
    //移动组分的贡献统计-新增
    private List<Contribution> moveNewContributionStatsList;
    //移动组分的贡献统计-更新
    private List<Contribution> moveUpdateContributionStatsList;
    

    //=============事务集=============

    //移入的组分-新增
    private List<Hierarchy> moveAddHierarchyListTL;
    //删除的组分-递归删除
    private List<Hierarchy> delHierarchyListTL;
    //移除的组分-简单删除
    private List<Hierarchy> moveDelHierarchyListTL;
    //重排的组分-更新排序
    private List<Hierarchy> reOrderHierarchyListTL;
    
    //删除的组分-删除
    private List<Concept> delConceptListTL;
    //重命名的组分-更新
    private List<Concept> renameConceptListTL;
    
    //新增组分的首发版本
    private List<Edition> newConceptEditionListTL;
    //新增组分-新增
    private List<Hierarchy> newHierarchyListTL;
    //新增组分-新增文章
    private List<Article> newArticleListTL;
    
    //版本确认
    private List<Edition> acceptEditionTL;
    //节点贡献值汇总
    private List<Contribution> acceptContributionTL;
    //节点用户贡献值汇总
    private List<Explorer> acceptExplorerTL;
    //节点更新的文章
    private List<Article> acceptArticleTL;
    //节点先删除文章段落
    private List<Paragraph> delParagraphListTL;
    //节点新增文章的段落
    private List<Paragraph> articleParagraphListTL;

    //当前的概念统计
    private List<Concept> thisConceptStatsListTL;
    //新增组分的概念统计
    private List<Concept> newConceptStatsListTL;
    //当前概念的贡献统计
    private List<Contribution> thisContributionStatsListTL;
    //新增组分的贡献统计
    private List<Contribution> newContributionStatsListTL;

    //移动组分的概念统计
    private List<Concept> moveConceptStatsListTL;
    //移动组分的贡献统计-新增
    private List<Contribution> moveNewContributionStatsListTL;
    //移动组分的贡献统计-更新
    private List<Contribution> moveUpdateContributionStatsListTL;
	
	//初始化
	public HierarchyAcceptAppearance(String token,EditionAcceptInit init) {
		super(token);
		this.init=init;
	}

	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd,this::qualifierGroup3rd,this::qualifierGroup4th);
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	
    	//当前审核的概念版本
    	PrincipleQualifier<Edition> editionQualifier=EditionQualify.PQ.pk(this.init.getId());

		return principleQualifiers.addOne(editionQualifier);
	};
    
	

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询
	 * @param relatedCollectionList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
    	this.source=new Source(principleSourceList);
    	this.thisEdition=this.source.getThisEdition();

    	//同一编辑事件的版本列表
    	PrincipleQualifier<Edition> sameEditEventEditionQualifier=EditionQualify.PQ.sameEditEventEditionList(this.thisEdition.getEventId());

    	return new PrincipleQualifiers(sameEditEventEditionQualifier);
    	
    }
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第三次查询
	 * @param relatedCollectionList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup3rd(List<PrincipleSource> principleSourceList) {
		this.sameEventEditionList=this.source.getSameEventEditionList();

	    //当前版本的组分分类
	    this.connotationDifferenceGroupFacet=new ConnotationDifferenceGroupFacet(this.thisEdition, this.sameEventEditionList);
	    
    	//当前版本的移动而新增的组分的上级节点列表
    	PrincipleQualifier<Hierarchy> directlySuperiorHierarchyListQualifier=Qualify.directlySuperiorHierarchyListQualifier(this.connotationDifferenceGroupFacet.getMoveAddList());
    	
    	
    	return new PrincipleQualifiers(directlySuperiorHierarchyListQualifier);
    	
    }
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第四次查询
	 * @param relatedCollectionList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup4th(List<PrincipleSource> principleSourceList) {
    	this.directlySuperiorHierarchyList=this.source.getDirectlySuperiorHierarchyList();
	    //因移入而新增的节点，需要找到移出节点的待评审节点
        this.supEditionHierarchyForMove=this.connotationDifferenceGroupFacet.querySupEditionHierarchyForMove(this.directlySuperiorHierarchyList);
	    if(this.supEditionHierarchyForMove.size()>0) {
	    	//抛出需要先评审删除节点的异常
            throw new BusinessException(203, String.valueOf(supEditionHierarchyForMove.getFirst().getConceptId()));
	    }
    	
    	//当前版本的上一个版本号
    	PrincipleQualifier<Edition> lastEditionQualifier=EditionQualify.PQ.lastEdition(this.thisEdition);

    	
    	//用户此概念上的所有审核版本
    	PrincipleQualifier<Edition> explorerConceptEditionListQualifier=EditionQualify.PQ.explorerConceptEditionList(this.thisEdition.getAuthorId(), this.thisEdition.getConceptId());
    	
    	//用户所有的贡献列表
		PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.explorerId(this.thisEdition.getAuthorId());
	    
    	//当前版本概念的外延直属列表[currentId,....topId]
    	PrincipleQualifier<Hierarchy> directlySuperiorHierarchyQualifier=HierarchyQualify.PQ.directlySuperiorHierarchyQualifier(this.thisEdition.getConceptId());
		

		//作为组分移动的概念列表
		PrincipleQualifier<Concept> conceptListForConnotation=Qualify.conceptList(this.connotationDifferenceGroupFacet.queryAddAndDelList());
		//作为组分移动的贡献列表
		PrincipleQualifier<Contribution> contributionListForConnotation=Qualify.contributionList(this.connotationDifferenceGroupFacet.queryAddAndDelList());
    	
		//要删除的段落列表
		PrincipleQualifier<Paragraph> delParagraphQualifier=ParagraphQualify.PQ.conceptId(this.thisEdition.getConceptId());
    	
		PrincipleQualifiers PrincipleQualifiers=new PrincipleQualifiers(lastEditionQualifier,explorerConceptEditionListQualifier,contributionQualifier,directlySuperiorHierarchyQualifier);
		PrincipleQualifiers.add(conceptListForConnotation,contributionListForConnotation,delParagraphQualifier);
		return PrincipleQualifiers;
    	
    }
    
    
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.lastEdition=this.source.getLastEdition();
	    this.explorerConceptEditionList=this.source.getExplorerConceptEditionList();
		this.userContributionList=this.source.userContributionList();
		this.superiorHierarchyList=this.source.getDirectlySuperiorHierarchy();
	    this.comUpdateConceptList=this.source.getComUpdateConceptList();
	    this.comUpdateContributionList=this.source.getComUpdateContributionList();
	    this.existParagraphList=this.source.getExistParagraphList();
		
	    //更新的内涵组分
	    this.hierarchyUpdateGroupFacet=new HierarchyUpdateGroupFacet(this.connotationDifferenceGroupFacet);

	    //新增组分的首发版本
	    this.newConceptsToEditionListFacet=new NewConceptsToEditionListFacet(this.thisEdition, this.hierarchyUpdateGroupFacet.getAddHierarchyList());
	    
		//版本本身
	    this.editionAcceptFacet=new EditionAcceptFacet(this.thisEdition);
	    
		return this;
	}
	


	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
		//版本通过
		this.editionAcceptFacet.accept(this.loginUser.getId(), this.init, this.lastEdition);
		//统计数：当前概念+新组分
		this.conceptCountForNewConceptsFacet=new ConceptCountForNewConceptsFacet(
				this.superiorHierarchyList, this.connotationDifferenceGroupFacet.getAddList(),this.thisEdition.getAuthorId());
		
		//统计数： 组分移动的概念
		this.conceptCountForMoveConceptsFacet=new ConceptCountForMoveConceptsFacet(
				this.superiorHierarchyList, this.connotationDifferenceGroupFacet, this.comUpdateConceptList, this.comUpdateContributionList);
		
		return this;
	}
	


	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

	    //移入的组分-新增
	    this.moveAddHierarchyList=this.hierarchyUpdateGroupFacet.getMoveAddHierarchyList();
	    //删除的组分-递归删除
	    this.delHierarchyList=this.hierarchyUpdateGroupFacet.getDelHierarchyList();
	    //移除的组分-简单删除
	    this.moveDelHierarchyList=this.hierarchyUpdateGroupFacet.getMoveDelHierarchyList();
	    //重排的组分-更新排序
	    this.reOrderHierarchyList=this.hierarchyUpdateGroupFacet.getReOrdelHierarchyList();
	    //删除的组分
	    this.delConceptList=this.hierarchyUpdateGroupFacet.getDelConceptList();
	    //重命名的组分-更新
	    this.renameConceptList=this.hierarchyUpdateGroupFacet.getRenameConceptList();
	    
	    //新增组分的首发版本
	    this.newConceptEditionList=this.newConceptsToEditionListFacet.getEditionList();
	    //新增组分-新增
	    this.newHierarchyList=this.newConceptsToEditionListFacet.getHierarchyList();
	    //新增组分-新增概念
	    //this.newConceptAddList=this.newConceptsToEditionListFacet.getConceptList();
	    //新增组分-新增文章
	    this.newArticleList=this.newConceptsToEditionListFacet.getArticleList();
	    //新增组分-新增贡献值
	    //this.newConceptContributionList=this.newConceptsToEditionListFacet.getContributionList();
	    
	    //版本确认
	    this.acceptEdition=this.editionAcceptFacet;
	    //节点贡献值汇总
	    this.acceptContribution=this.editionAcceptFacet.getAuthorUpdateContribution(this.explorerConceptEditionList);
	    //节点用户贡献值汇总
	    this.acceptExplorer=this.editionAcceptFacet.getExplorerUpdateForContribution(this.userContributionList);
	    //节点更新的文章
	    this.acceptArticle=this.editionAcceptFacet.getArticle();
	    //节点先删除文章段落
	    this.delParagraphList=this.existParagraphList;
	    //节点新增文章的段落
	    this.articleParagraphList=this.editionAcceptFacet.getNewParagraphList();
	    

	    //当前的概念统计
	    this.thisConceptStatsList=this.conceptCountForNewConceptsFacet.getUpdateCountToConceptList();
	    //新增组分的概念统计
	    this.newConceptStatsList=this.conceptCountForNewConceptsFacet.getNewCountToConceptList(this.newConceptsToEditionListFacet.getConceptList());
	    //当前概念的贡献统计
	    this.thisContributionStatsList=this.conceptCountForNewConceptsFacet.getUpdateCountToContributionList();
	    //新增组分的贡献统计
	    this.newContributionStatsList=this.conceptCountForNewConceptsFacet.getNewCountToContributionList(this.newConceptsToEditionListFacet.getContributionList());

	    //移动组分的概念统计
	    this.moveConceptStatsList=this.conceptCountForMoveConceptsFacet.getCombineConcepCount();
	    //移动组分的贡献统计-新增
	    this.moveNewContributionStatsList=this.conceptCountForMoveConceptsFacet.getNewCountToContributionList(this.userContributionList);
	    //移动组分的贡献统计-更新
	    this.moveUpdateContributionStatsList=this.conceptCountForMoveConceptsFacet.getUpdateCountToContributionList(this.userContributionList);
		


	    
		//==================组成返回值==================

	 // 移入的组分-新增
	    this.moveAddHierarchyListTL = this.moveAddHierarchyList;
	    // 删除的组分-递归删除
	    this.delHierarchyListTL = HierarchyImagine.delRecursive(this.delHierarchyList, this.connotationDifferenceGroupFacet.getEventAddConceptMap());
	    // 移除的组分-简单删除
	    this.moveDelHierarchyListTL = this.moveDelHierarchyList;
	    // 重排的组分-更新排序
	    this.reOrderHierarchyListTL = this.reOrderHierarchyList;

	    // 删除的组分-删除
	    this.delConceptListTL = this.delConceptList;
	    // 重命名的组分-更新
	    this.renameConceptListTL = this.renameConceptList;

	    // 新增组分的首发版本
	    this.newConceptEditionListTL = this.newConceptEditionList;
	    // 新增组分-新增
	    this.newHierarchyListTL = this.newHierarchyList;
	    // 新增组分-新增文章
	    this.newArticleListTL = this.newArticleList;

	    // 版本确认
	    this.acceptEditionTL = Arrays.asList(this.acceptEdition);
	    // 节点贡献值汇总
	    this.acceptContributionTL = Arrays.asList(this.acceptContribution);
	    // 节点用户贡献值汇总
	    this.acceptExplorerTL = Arrays.asList(this.acceptExplorer);
	    // 节点更新的文章
	    this.acceptArticleTL = Arrays.asList(this.acceptArticle);
	    // 节点先删除文章段落
	    this.delParagraphListTL = this.delParagraphList;
	    // 节点新增文章的段落
	    this.articleParagraphListTL = this.articleParagraphList;

	    // 当前的概念统计
	    this.thisConceptStatsListTL = this.thisConceptStatsList;
	    // 新增组分的概念统计
	    this.newConceptStatsListTL = this.newConceptStatsList;
	    // 当前概念的贡献统计
	    this.thisContributionStatsListTL = this.thisContributionStatsList;
	    // 新增组分的贡献统计
	    this.newContributionStatsListTL = this.newContributionStatsList;

	    // 移动组分的概念统计
	    this.moveConceptStatsListTL = this.moveConceptStatsList;
	    // 移动组分的贡献统计-新增
	    this.moveNewContributionStatsListTL = this.moveNewContributionStatsList;
	    // 移动组分的贡献统计-更新
	    this.moveUpdateContributionStatsListTL = this.moveUpdateContributionStatsList;
	    
	    
		List<List<? extends Principle<?>>> addition=Arrays.asList(
				this.moveAddHierarchyListTL,
				this.newConceptEditionListTL,
				this.newHierarchyListTL,
				this.newArticleListTL,
				this.articleParagraphListTL,
				this.newConceptStatsListTL,
				this.newContributionStatsListTL,
				this.moveNewContributionStatsListTL
        		);

		List<List<? extends Principle<?>>> modification=Arrays.asList(
				this.reOrderHierarchyListTL,
				this.renameConceptListTL,
				this.acceptEditionTL,
				this.acceptContributionTL,
				this.acceptExplorerTL,
				this.acceptArticleTL,
				this.thisConceptStatsListTL,
				this.thisContributionStatsListTL,
				this.moveConceptStatsListTL,
				this.moveUpdateContributionStatsListTL
				);
		
		List<List<? extends Principle<?>>> deletion=Arrays.asList(
				this.moveDelHierarchyListTL,
				this.delHierarchyListTL,
				this.delConceptListTL,
				this.delParagraphListTL
				);
		
		return new PrincipleImage(addition,modification,deletion);
	};

	/**
	 * 事务标识组
	 * @return
	 */
	@Override
	public TransactionGroupList transactionGroupList() {
		
		List<List<? extends Principle<?>>> groupA=Arrays.asList(
				this.moveAddHierarchyListTL,
				this.newConceptEditionListTL,
				this.newHierarchyListTL,
				this.newArticleListTL,
				this.articleParagraphListTL,
				this.newConceptStatsListTL,
				this.newContributionStatsListTL,
				this.moveNewContributionStatsListTL,

				this.reOrderHierarchyListTL,
				this.renameConceptListTL,
				this.acceptEditionTL,
				this.acceptContributionTL,
				this.acceptExplorerTL,
				this.acceptArticleTL,
				this.thisConceptStatsListTL,
				this.thisContributionStatsListTL,
				this.moveConceptStatsListTL,
				this.moveUpdateContributionStatsListTL,

				this.moveDelHierarchyListTL,
				this.delHierarchyListTL,
				this.delConceptListTL,
				this.delParagraphListTL);

		return new TransactionGroupList(groupA);
	}; 
	
}
