package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.OptionalDouble;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

/**
 * 版本扩展
 */
class EditionAcceptFacet extends Edition{

	private static final long serialVersionUID = 1L;


	EditionAcceptFacet(Edition edition) {
		GenericMapper.INSTANCE.toFacet(edition, this);
	}
	
	
	/**
	 * 版本转文章
	 * @param editionModel
	 * @return
	 */
	Article getArticle() {
		Edition editionModel=this;
		Article articleModel=new Article();
		articleModel.setId(editionModel.getConceptId());
		articleModel.setEditionId(editionModel.getId());
		articleModel.setLastAuthorId(editionModel.getAuthorId());
		articleModel.setUpdateAbstract(editionModel.getDigest());
		articleModel.setCentralIdea(editionModel.getCentralIdea());
		articleModel.setReference(editionModel.getReference());
		articleModel.setUpdateTime(editionModel.getCreateTime());
		articleModel.setEsSync(1);
		return articleModel;
	}
 
	
	/**
	 * 版本确认
	 * @param graderId
	 * @param grade
	 * @param contribution
	 */
    void accept(Long graderId,EditionAcceptInit acceptInit,Edition lastEdition) {
    	setGraderId(graderId);
    	setGrade(acceptInit.getGrade());
    	setContribution(acceptInit.getContribution());
    	setCheckStatus(1);
    	setCheckTime(new Date());

		Integer editionNum=1;
		if(null!=lastEdition && 0<lastEdition.getEdition()){
			editionNum=lastEdition.getEdition()+1;
		}
    	setEdition(editionNum);
    }
	

	/**
	 * 用户贡献值更新：领域评分取均值，领域贡献设累加值
	 * @param explorerConceptEditionList
	 * @return
	 */
	Contribution getAuthorUpdateContribution(List<Edition> explorerConceptEditionList) {
		Edition edition=this;

		//添加领域贡献值
		Contribution editionContribution=new Contribution();
		editionContribution.setConceptId(edition.getConceptId());
		editionContribution.setExplorerId(edition.getAuthorId());
		
		//计算领域平均分
		List<Edition> newList = new ArrayList<>(explorerConceptEditionList);
		newList.add(edition);
		OptionalDouble average = newList.stream()
                .mapToInt(Edition::getGrade) 
                .average();
			
		Double newGrade=average.orElse(0.0);
		editionContribution.setGrade(newGrade.intValue());
		editionContribution.setContribution(edition.getContribution());
		return editionContribution;
	}

	/**
	 * 贡献值汇总统计更新到作者上
	 * @param edition
	 * @param userContributionList
	 * @return
	 */
	Explorer getExplorerUpdateForContribution(List<Contribution> userContributionList) {
		Edition edition=this;

		Explorer explorerGrade=new Explorer();
		explorerGrade.setId(edition.getAuthorId());
		
		
		Contribution thisContribution=new Contribution();
		thisContribution.setGrade(edition.getGrade());
		thisContribution.setContribution(edition.getContribution());
		List<Contribution> newList = new ArrayList<>(userContributionList);
		newList.add(thisContribution);

		OptionalDouble average = newList.stream()
                .mapToInt(Contribution::getGrade) 
                .average();
		

		Integer sum = newList.stream()
                .mapToInt(Contribution::getGrade) 
                .sum();
		

		Double newGrade=average.orElse(0.0);
		explorerGrade.setGrade(newGrade.intValue());
		explorerGrade.setContribution(sum);
		
		return explorerGrade;
	}
	
	public List<Paragraph> getNewParagraphList() {
		List<Paragraph> list=this.getParagraphList();
		if(null!=list) {
			list.stream().forEach(p -> p.setId(StaticSnowflake.generateId(1, TableIdEnum.PARAGRAPH.getTableId())));
		}
		return list;
	}
	
}
