package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;

/**
 * 版本的组分分类
 */
class ConnotationDifferenceGroupFacet {

	private List<ConnotationDifference> addList;//新增
	private List<ConnotationDifference> moveAddList;//移进
	private List<ConnotationDifference> delList;//删除
	private List<ConnotationDifference> moveDelList;//移出（识别删除还是移出）
	private List<ConnotationDifference> renameList;//改名
	private boolean isReOrder;//是否改了顺序
	
	//本次编辑事件中，所有新增的节点
	private Map<Long,ConnotationDifference> eventAddConceptMap;
	
	//暂存的版本和列表
	private Edition thisEdition;
	private List<Edition> eventEditionList;
	
	/**
	 * 当前版本的组分分类：
	 * @param thisEdition 当前版本
	 * @param eventEditionList 同一事件的全部版本（识别删除还是移出）
	 */
	ConnotationDifferenceGroupFacet(Edition thisEdition,List<Edition> eventEditionList) {
		this.addList=new ArrayList<>();
		this.moveAddList=new ArrayList<>();
		this.delList=new ArrayList<>();
		this.moveDelList=new ArrayList<>();
		this.renameList=new ArrayList<>();
		
		this.thisEdition=thisEdition;
		this.eventEditionList=eventEditionList;
		List<ConnotationDifference> connotationDifferenceList=thisEdition.getConnotationDifferenceList();
		//查询本次操作事件中，移动而新增的点
		Map<Long,ConnotationDifference> addConceptMap=eventEditionList.stream()
	            .filter(edition -> edition.getConnotationDifferenceList() != null && !edition.getConnotationDifferenceList().isEmpty())
	            .flatMap(edition -> edition.getConnotationDifferenceList().stream())
	            .filter(diff -> Integer.valueOf(1).equals(diff.getUpdateType()))
	            .collect(Collectors.toMap(ConnotationDifference::getConceptId,  Function.identity()                      
	            ));
		
		this.eventAddConceptMap=addConceptMap;
		boolean isEditComp=(null!=connotationDifferenceList && connotationDifferenceList.size()>0);
		if(!isEditComp) {
			return;
		}
		
		for (int i = 0; i < connotationDifferenceList.size(); i++) {
			ConnotationDifference oneCm=connotationDifferenceList.get(i);
			Integer updateType=oneCm.getUpdateType();
			switch (updateType) {
				case 1:
					Long waitId=oneCm.getWaitConceptId();
					if(null!=waitId && 1L==waitId){
						addList.add(oneCm);	
					}else{
						moveAddList.add(oneCm);
					}
					break;
				case 2:
					//需要区分是删除的还是移走的
					Long conceptId=oneCm.getConceptId();
					if(addConceptMap.containsKey(conceptId)) {
						moveDelList.add(oneCm);
					}else {
						delList.add(oneCm);	
					}
					break;
				case 3:isReOrder=true;	break;
				case 4:renameList.add(oneCm);	break;
				default:break;
			}
		}
		
	}
	

	/**
	 * 移进和删除的组分
	 * @return
	 */
	List<ConnotationDifference> queryAddAndDelList(){
		return Stream.concat(this.moveAddList.stream(), this.delList.stream())
                .collect(Collectors.toList());
	}

	

	/**
	 * 当前版本的移动而新增的组分的上级节点列表
	 * 在本次编辑的提交待评审版本里
	 * 
	 * 
	 * @param moveAddList 
	 * @param directlySuperiorHierarchyList 
	 * @return
	 */
	List<Hierarchy> querySupEditionHierarchyForMove(List<Hierarchy> directlySuperiorHierarchyList){
		List<ConnotationDifference> moveAddList=this.moveAddList;
		List<Edition> editionList=this.eventEditionList;
		List<Hierarchy> supEditionHierarchyForMoveList=new ArrayList<>();
		
		
		Map<Long, Edition> editionMap = editionList.stream()
				.filter(e -> 0==e.getCheckStatus())
				.collect(Collectors.toMap(Edition::getId, Function.identity()));
		
		Map<Long,List<Hierarchy>> superiorHierarchyListMap = directlySuperiorHierarchyList.stream()
			    .collect(Collectors.groupingBy(Hierarchy::getSuperiorId));
		
		
		for (ConnotationDifference connotationDifference : moveAddList) {
			Long conceptId=connotationDifference.getConceptId();
			List<Hierarchy> hierarchyList=superiorHierarchyListMap.get(conceptId);
			for (Hierarchy hierarchy : hierarchyList) {
				if(editionMap.containsKey(hierarchy.getConceptId())) {
					if(!conceptId.equals(hierarchy.getConceptId())) {
						supEditionHierarchyForMoveList.add(hierarchy);
					}
				}
			}
		}
		
		return supEditionHierarchyForMoveList;
	}
	
	

	
	
	List<ConnotationDifference> getAddList() {
		return addList;
	}
	List<ConnotationDifference> getMoveAddList() {
		return moveAddList;
	}
	List<ConnotationDifference> getDelList() {
		return delList;
	}
	List<ConnotationDifference> getMoveDelList() {
		return moveDelList;
	}
	List<ConnotationDifference> getRenameList() {
		return renameList;
	}
	boolean isReOrder() {
		return isReOrder;
	}

	Edition getThisEdition() {
		return thisEdition;
	}


	Map<Long,ConnotationDifference> getEventAddConceptMap() {
		return eventAddConceptMap;
	}

}
