package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountCombineListFacet;
import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.DeepClone;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

/**
 * 版本通过概念统计数: 当前节点a1
 */
class ConceptCountForNewConceptsFacet {
	//当前概念编辑数+1
	private ConceptUpdateCountFacet thisConceptUpdateCount;
	//子节点新增数
	private List<ConceptUpdateCountFacet> addConceptListUpdateCount;
	//合并更新数
	private ConceptUpdateCountCombineListFacet conceptUpdateCountCombineList;

	//辅助变量：当前的+组分添加的统计数
	private List<Concept> concetpList;
	private List<Contribution> contributionList;
	
	/**
	 * 版本通过编辑数
	 * @param superiorIdList
	 * @param addList
	 */
	ConceptCountForNewConceptsFacet(List<Hierarchy> superiorHierarchyList,List<ConnotationDifference> addList,Long explorerId) {
		
		List<Long> superiorIdList=superiorHierarchyList.stream()
			    .map(concept -> concept.getConceptId())
			    .collect(Collectors.toList())
			    .reversed()
		        .stream() 
		        .collect(Collectors.toList()); 

		//========当前概念编辑数+1==========
		this.thisConceptUpdateCount=new ConceptUpdateCountFacet(DeepClone.deepClone(superiorIdList));
		thisConceptUpdateCount.setCountEditCompOrArt(1);
		thisConceptUpdateCount.setIsEditCompOrArt(1);
		

		//===========组分新建: 组分创建数+1===========
		List<ConceptUpdateCountFacet> updateCountList=new ArrayList<ConceptUpdateCountFacet>();
		for (int i = 0; i < addList.size(); i++) {
			ConnotationDifference oneAddConnotation=addList.get(i);
			List<Long> subSuperiorIdList=DeepClone.deepClone(superiorIdList);
			subSuperiorIdList.add(oneAddConnotation.getConceptId());
			
			ConceptUpdateCountFacet subCountModel=new ConceptUpdateCountFacet();
			subCountModel.setSuperiorIdList(subSuperiorIdList);
			subCountModel.setCountCreate(1);
			subCountModel.setIsCreate(1);
			updateCountList.add(subCountModel);
		}
		this.addConceptListUpdateCount=updateCountList;
		
		//======================合并更新数==========================
		List<ConceptUpdateCountFacet> newMergedList = Stream.concat(
				this.addConceptListUpdateCount.stream(),
                Stream.of(thisConceptUpdateCount)
        ).collect(Collectors.toList());
		this.conceptUpdateCountCombineList=new ConceptUpdateCountCombineListFacet(newMergedList);
		
		this.concetpList=this.conceptUpdateCountCombineList.getUpdateCountToConceptList(ConceptUpdateCountFacet::acceptToConcept);
		this.contributionList=this.conceptUpdateCountCombineList.getUpdateContributionList(explorerId,(oneUpdateCount, eId) -> oneUpdateCount.acceptToContribution(eId));
		
	}

	


    /**
     * 更新的统计数转概念列表
     * @param combineUpdateConutList
     * @return
     */
	List<Concept> getUpdateCountToConceptList() {
		Long existConceptId=this.thisConceptUpdateCount.getSuperiorIdList().getLast();
		return this.concetpList.stream()
                .filter(concept -> existConceptId.equals(concept.getId()))
                .collect(Collectors.toList());
	}
    /**
     * 新增的统计数转概念列表
     * @param combineUpdateConutList
     * @return
     */
	List<Concept> getNewCountToConceptList(List<Concept> newConceptList) {
		Map<Long, Concept> conceptMap = newConceptList.stream()
		        .collect(Collectors.toMap(Concept::getId, Function.identity()));
		
		
		//Long existConceptId=this.thisConceptUpdateCount.getSuperiorIdList().getLast();
		List<Concept> list= this.concetpList.stream()
                .filter(concept -> !this.thisConceptUpdateCount.getSuperiorIdList().contains(concept.getId()))
                .map(c -> {
                	Concept nameConcept=conceptMap.get(c.getId());
                	if(null!=nameConcept) {
                		c.setName(nameConcept.getName());
                		c.setCreateTime(nameConcept.getCreateTime());
                	}
                	return c;
                })
                .collect(Collectors.toList());
		
		
		return list;
		
	}

	
    /**
     * 更新统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getUpdateCountToContributionList() {
		Long existConceptId=this.thisConceptUpdateCount.getSuperiorIdList().getLast();
		return this.contributionList.stream()
                .filter(contribution -> existConceptId.equals(contribution.getConceptId()))
                .collect(Collectors.toList());
	}
    
    /**
     * 新增统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getNewCountToContributionList(List<Contribution> newConceptContributionList) {

		Map<Long, Contribution> contributionMap = newConceptContributionList.stream()
		        .collect(Collectors.toMap(Contribution::getConceptId, Function.identity()));
		
		//Long existConceptId=this.thisConceptUpdateCount.getSuperiorIdList().getLast();
		List<Contribution> list= this.contributionList.stream()
                //.filter(contribution -> !existConceptId.equals(contribution.getConceptId()))
                .filter(contribution -> !this.thisConceptUpdateCount.getSuperiorIdList().contains(contribution.getConceptId()))
                .map(contribution -> {
                	Contribution uk=contributionMap.get(contribution.getConceptId());
                	if(null!=uk) {
                		contribution.setId(uk.getId());
                		contribution.setGrade(uk.getGrade());
                		contribution.setContribution(uk.getContribution());
                	}else {
                		Long contributionId=StaticSnowflake.generateId(1, TableIdEnum.CONTRIBUTION.getTableId());
                		contribution.setId(contributionId);
                	}
                	return contribution;
                	
                })
                .collect(Collectors.toList());
		
		return list;
	}
	
	
}
