package xyz.zhiwei.article.morphism.appearance.hierarchy.accept;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;
import xyz.zhiwei.article.morphism.support.facet.AddAndUpdateGroupFacet;
import xyz.zhiwei.article.morphism.support.util.DeepClone;



/**
 * 统计：组分删除和迁移
 */
class ConceptCountForMoveConceptsFacet {
	private List<WithSuperIdList<Concept>> moveAddConceptList;
	private List<WithSuperIdList<Concept>> delConceptList;
	private List<WithSuperIdList<Contribution>> moveAddContributionList;
	private List<WithSuperIdList<Contribution>> delContributionList;
	

	//辅助变量：更新统计数转贡献列表
	private List<Contribution> contributionList;
	
	/**
	 * 统计：组分删除和迁移
	 * @param superiorHierarchyList 上级节点列表
	 * @param connotationDifferenceFacet 节点更新分类
	 * @param comUpdateConceptList 已有概念的统计列表
	 * @param comUpdateContributionList 已有贡献的统计列表
	 */
	ConceptCountForMoveConceptsFacet(List<Hierarchy> superiorHierarchyList,ConnotationDifferenceGroupFacet connotationDifferenceFacet,
			List<Concept> comUpdateConceptList,List<Contribution> comUpdateContributionList) {
		this.moveAddConceptList=new ArrayList<>();
		this.delConceptList=new ArrayList<>();
		this.moveAddContributionList=new ArrayList<>();
		this.delContributionList=new ArrayList<>();
		
		
		
		List<Long> superiorIdList=superiorHierarchyList.stream()
			    .map(concept -> concept.getConceptId())
			    .collect(Collectors.toList())
			    .reversed();
		
		Map<Long, Concept> conceptDbMap =comUpdateConceptList.stream().collect(Collectors.toMap(Concept::getId, Function.identity()));
		Map<Long, List<Contribution>> contributionDbMap = comUpdateContributionList.stream().collect(Collectors.groupingBy(Contribution::getConceptId));
		
		

		List<ConnotationDifference> moveAddList=connotationDifferenceFacet.getMoveAddList();
		List<ConnotationDifference> delList=new ArrayList<>(connotationDifferenceFacet.getDelList());
		delList.addAll(connotationDifferenceFacet.getMoveDelList());
		

		//======================================共享概念统计======================================
		//===========组分移进: 当前概念所有统计数+组分统计数===========
		for (int i = 0; i < moveAddList.size(); i++) {
			ConnotationDifference oneMoveAddConnotation=moveAddList.get(i);
			Concept oneMoveAddConcept=conceptDbMap.get(oneMoveAddConnotation.getConceptId());
			if(null==oneMoveAddConcept) {
				continue;
			}
			List<Long> subSuperiorIdList=DeepClone.deepClone(superiorIdList);
			this.moveAddConceptList.add(new WithSuperIdList<>(oneMoveAddConcept,subSuperiorIdList));
		}
		
		
		//===========组分移除: 当前概念所有统计数-组分统计数===========
		for (int i = 0; i < delList.size(); i++) {
			ConnotationDifference oneDelConnotation=delList.get(i);
			Concept oneDelConcept=conceptDbMap.get(oneDelConnotation.getConceptId());
			if(null==oneDelConcept) {
				continue;
			}
			List<Long> subSuperiorIdList=DeepClone.deepClone(superiorIdList);
			this.delConceptList.add(new WithSuperIdList<>(oneDelConcept,subSuperiorIdList));
		}
		
		
		
		//======================================贡献值统计======================================
		//===========组分移进: 当前概念所有统计数+组分统计数===========
		//查询贡献的统计信息
		for (int i = 0; i < moveAddList.size(); i++) {
			ConnotationDifference oneMoveAddConnotation=moveAddList.get(i);
			List<Contribution> oneMoveAddContributionList=contributionDbMap.get(oneMoveAddConnotation.getConceptId());
			for (Contribution oneMoveAddContribution : oneMoveAddContributionList) {
				List<Long> subSuperiorIdList=DeepClone.deepClone(superiorIdList);
				this.moveAddContributionList.add(new WithSuperIdList<>(oneMoveAddContribution,subSuperiorIdList));
			}
			
		}

		//===========组分移除: 当前概念所有统计数-组分统计数===========
		//查询贡献的统计信息
		for (int i = 0; i < delList.size(); i++) {
			ConnotationDifference oneDelConnotation=delList.get(i);
			List<Contribution> oneDelContributionList=contributionDbMap.get(oneDelConnotation.getConceptId());
			for (Contribution oneDelContribution : oneDelContributionList) {
				List<Long> subSuperiorIdList=DeepClone.deepClone(superiorIdList);
				this.delContributionList.add(new WithSuperIdList<>(oneDelContribution,subSuperiorIdList));
			}
		}
	}
	
	
    /**
     * 更新统计数转贡献列表
     * @param combineUpdateConutList
     * @param explorerId
     * @param userContributionList 用户已存在的的贡献值列表
     * @return
     */
	List<Contribution> getUpdateCountToContributionList(List<Contribution> userContributionList) {
		if(null==this.contributionList) {
			List<Contribution> contributionList=this.getCombineContributionCount();
			this.contributionList=contributionList;
		}
		//=====贡献数分为新增和更新====
	    AddAndUpdateGroupFacet<Contribution> contributionGroup=new AddAndUpdateGroupFacet<>(this.contributionList, userContributionList,
				Contribution::uniqueKey, Contribution::getId, Contribution::setId);

		return contributionGroup.getModification();
	} 
	
    /**
     * 更新统计数转贡献列表
     * @param combineUpdateConutList
     * @param explorerId
     * @param userContributionList 用户已存在的的贡献值列表
     * @return
     */
	List<Contribution> getNewCountToContributionList(List<Contribution> userContributionList) {
		if(null==this.contributionList) {
			List<Contribution> contributionList=this.getCombineContributionCount();
			this.contributionList=contributionList;
		}
		//=====贡献数分为新增和更新====
	    AddAndUpdateGroupFacet<Contribution> contributionGroup=new AddAndUpdateGroupFacet<>(this.contributionList, userContributionList,
				Contribution::uniqueKey, Contribution::getId, Contribution::setId);

		return contributionGroup.getAddition();
	} 
	

	/**
	 * 合并更新数
	 * superiorIdList:从上到下,包括当前id
	 * @return
	 */
	List<Concept> getCombineConcepCount(){
		
		Map<Long,Concept> updateConceptMap=new HashMap<>();
		
		for (int i = 0; i < this.moveAddConceptList.size(); i++) {
			WithSuperIdList<Concept> oneMoveAddConceptModel=this.moveAddConceptList.get(i);
			List<Long> superiorIdList=oneMoveAddConceptModel.getSuperiorIdList();
			//累计值
			for (int j = 0; j < superiorIdList.size(); j++) {
				Long oneSuperiorId=superiorIdList.get(j);
				Concept oneConceptCountModel=updateConceptMap.get(oneSuperiorId);
				if(null==oneConceptCountModel){
					oneConceptCountModel=new Concept();
					oneConceptCountModel.setId(oneSuperiorId);
					updateConceptMap.put(oneSuperiorId, oneConceptCountModel);
				}
				addConceptCount(oneConceptCountModel, oneMoveAddConceptModel.getT());
			}
		}
		

		for (int i = 0; i < this.delConceptList.size(); i++) {
			WithSuperIdList<Concept> oneDelConceptModel=this.delConceptList.get(i);
			List<Long> superiorIdList=oneDelConceptModel.getSuperiorIdList();
			//累计值
			for (int j = 0; j < superiorIdList.size(); j++) {
				Long oneSuperiorId=superiorIdList.get(j);
				Concept oneConceptCountModel=updateConceptMap.get(oneSuperiorId);
				if(null==oneConceptCountModel){
					oneConceptCountModel=new Concept();
					oneConceptCountModel.setId(oneSuperiorId);
					updateConceptMap.put(oneSuperiorId, oneConceptCountModel);
				}
				delConceptCount(oneConceptCountModel, oneDelConceptModel.getT());
			}
		}
		
		List<Concept> combineUpdateConutList=new ArrayList<>();
		for (Long id:updateConceptMap.keySet()) {
			Concept oneUpdateCountModel=updateConceptMap.get(id);
			combineUpdateConutList.add(oneUpdateCountModel);
		}
		return combineUpdateConutList;
	}
	 
	/**
	 * 合并更新数
	 * superiorIdList:从上到下,包括当前id
	 * @return
	 */
	private List<Contribution> getCombineContributionCount(){
		
		//<explorerId,ConceptId,Contribution>
		Map<Long,Map<Long,Contribution>> explorerMap=new HashMap<>();
		
		
		for (int i = 0; i < this.moveAddContributionList.size(); i++) {
			WithSuperIdList<Contribution> oneMoveAddConceptModel=this.moveAddContributionList.get(i);
			
			Long explorerId=oneMoveAddConceptModel.getT().getExplorerId();
			Map<Long,Contribution> oneExplorerMap=explorerMap.get(explorerId);
			if(null==oneExplorerMap){
				oneExplorerMap=new HashMap<Long,Contribution>();
				explorerMap.put(explorerId, oneExplorerMap);
			}
			
			
			List<Long> superiorIdList=oneMoveAddConceptModel.getSuperiorIdList();
			//累计值
			for (int j = 0; j < superiorIdList.size(); j++) {
				Long oneSuperiorId=superiorIdList.get(j);
				Contribution oneConceptCountModel=oneExplorerMap.get(oneSuperiorId);
				if(null==oneConceptCountModel){
					oneConceptCountModel=new Contribution();
					oneConceptCountModel.setConceptId(oneSuperiorId);
					oneConceptCountModel.setExplorerId(explorerId);
					oneExplorerMap.put(oneSuperiorId, oneConceptCountModel);
				}
				addContributionCount(oneConceptCountModel, oneMoveAddConceptModel.getT());
			}
		}
		

		for (int i = 0; i < this.delContributionList.size(); i++) {
			WithSuperIdList<Contribution> oneDelConceptModel=this.delContributionList.get(i);

			Long explorerId=oneDelConceptModel.getT().getExplorerId();
			Map<Long,Contribution> oneExplorerMap=explorerMap.get(explorerId);
			if(null==oneExplorerMap){
				oneExplorerMap=new HashMap<Long,Contribution>();
				explorerMap.put(explorerId, oneExplorerMap);
			}
			
			List<Long> superiorIdList=oneDelConceptModel.getSuperiorIdList();
			//累计值
			for (int j = 0; j < superiorIdList.size(); j++) {
				Long oneSuperiorId=superiorIdList.get(j);
				Contribution oneConceptCountModel=oneExplorerMap.get(oneSuperiorId);
				if(null==oneConceptCountModel){
					oneConceptCountModel=new Contribution();
					oneConceptCountModel.setConceptId(oneSuperiorId);
					oneConceptCountModel.setExplorerId(explorerId);
					oneExplorerMap.put(oneSuperiorId, oneConceptCountModel);
				}
				delContributionCount(oneConceptCountModel, oneDelConceptModel.getT());
			}
		}
		
		List<Contribution> combineUpdateConutList=new ArrayList<Contribution>();
		for(Long explorerId:explorerMap.keySet()){
			Map<Long,Contribution> oneExplorerMap=explorerMap.get(explorerId);
			for (Long id:oneExplorerMap.keySet()) {
				Contribution oneUpdateCountModel=oneExplorerMap.get(id);
				combineUpdateConutList.add(oneUpdateCountModel);
			}
		}
		return combineUpdateConutList;
	}
	
	
	
	
	
	
	
	

	/**
	 * 添加计数
	 * @param oneContributionCount
	 * @param oneMoveAddContribution
	 */
	private void addContributionCount(Contribution oneContributionCount,Contribution oneMoveAddContribution){
		
		oneContributionCount.setCenturyCountAll(oneContributionCount.getCenturyCountAll()+oneMoveAddContribution.getCenturyCountAll());
		oneContributionCount.setCenturyCountCreate(oneContributionCount.getCenturyCountCreate()+oneMoveAddContribution.getCenturyCountCreate());
		oneContributionCount.setCenturyCountEdit(oneContributionCount.getCenturyCountEdit()+oneMoveAddContribution.getCenturyCountEdit());
		oneContributionCount.setCenturyCountDiscussion(oneContributionCount.getCenturyCountDiscussion()+oneMoveAddContribution.getCenturyCountDiscussion());
		

		oneContributionCount.setWaitCountAll(oneContributionCount.getWaitCountAll()+oneMoveAddContribution.getWaitCountAll());
		oneContributionCount.setWaitCountCreate(oneContributionCount.getWaitCountCreate()+oneMoveAddContribution.getWaitCountCreate());
		oneContributionCount.setWaitCountEdit(oneContributionCount.getWaitCountEdit()+oneMoveAddContribution.getWaitCountEdit());
		oneContributionCount.setWaitCountDiscussion(oneContributionCount.getWaitCountDiscussion()+oneMoveAddContribution.getWaitCountDiscussion());

		oneContributionCount.setRefuseCountAll(oneContributionCount.getRefuseCountAll()+oneMoveAddContribution.getRefuseCountAll());
		oneContributionCount.setRefuseCountCreate(oneContributionCount.getRefuseCountCreate()+oneMoveAddContribution.getRefuseCountCreate());
		oneContributionCount.setRefuseCountEdit(oneContributionCount.getRefuseCountEdit()+oneMoveAddContribution.getRefuseCountEdit());
		oneContributionCount.setRefuseCountDiscussion(oneContributionCount.getRefuseCountDiscussion()+oneMoveAddContribution.getRefuseCountDiscussion());
	}

	

	/**
	 * 减去计数
	 * @param oneContributionCount
	 * @param oneDelContribution
	 */
	private void delContributionCount(Contribution oneContributionCount,Contribution oneDelContribution){
		
		oneContributionCount.setCenturyCountAll(oneContributionCount.getCenturyCountAll()-oneDelContribution.getCenturyCountAll());
		oneContributionCount.setCenturyCountCreate(oneContributionCount.getCenturyCountCreate()-oneDelContribution.getCenturyCountCreate());
		oneContributionCount.setCenturyCountEdit(oneContributionCount.getCenturyCountEdit()-oneDelContribution.getCenturyCountEdit());
		oneContributionCount.setCenturyCountDiscussion(oneContributionCount.getCenturyCountDiscussion()-oneDelContribution.getCenturyCountDiscussion());
		

		oneContributionCount.setWaitCountAll(oneContributionCount.getWaitCountAll()-oneDelContribution.getWaitCountAll());
		oneContributionCount.setWaitCountCreate(oneContributionCount.getWaitCountCreate()-oneDelContribution.getWaitCountCreate());
		oneContributionCount.setWaitCountEdit(oneContributionCount.getWaitCountEdit()-oneDelContribution.getWaitCountEdit());
		oneContributionCount.setWaitCountDiscussion(oneContributionCount.getWaitCountDiscussion()-oneDelContribution.getWaitCountDiscussion());

		oneContributionCount.setRefuseCountAll(oneContributionCount.getRefuseCountAll()-oneDelContribution.getRefuseCountAll());
		oneContributionCount.setRefuseCountCreate(oneContributionCount.getRefuseCountCreate()-oneDelContribution.getRefuseCountCreate());
		oneContributionCount.setRefuseCountEdit(oneContributionCount.getRefuseCountEdit()-oneDelContribution.getRefuseCountEdit());
		oneContributionCount.setRefuseCountDiscussion(oneContributionCount.getRefuseCountDiscussion()-oneDelContribution.getRefuseCountDiscussion());
	}

	
	
	
	
	/**
	 * 添加计数
	 * @param oneConceptCount
	 * @param oneMoveAddConcept
	 */
	private void addConceptCount(Concept oneConceptCount,Concept oneMoveAddConcept){
		
		oneConceptCount.setCenturyCountAll(oneConceptCount.getCenturyCountAll()+oneMoveAddConcept.getCenturyCountAll());
		oneConceptCount.setCenturyCountCreate(oneConceptCount.getCenturyCountCreate()+oneMoveAddConcept.getCenturyCountCreate());
		oneConceptCount.setCenturyCountEdit(oneConceptCount.getCenturyCountEdit()+oneMoveAddConcept.getCenturyCountEdit());
		oneConceptCount.setCenturyCountDiscussion(oneConceptCount.getCenturyCountDiscussion()+oneMoveAddConcept.getCenturyCountDiscussion());
		

		oneConceptCount.setWaitCountAll(oneConceptCount.getWaitCountAll()+oneMoveAddConcept.getWaitCountAll());
		oneConceptCount.setWaitCountCreate(oneConceptCount.getWaitCountCreate()+oneMoveAddConcept.getWaitCountCreate());
		oneConceptCount.setWaitCountEdit(oneConceptCount.getWaitCountEdit()+oneMoveAddConcept.getWaitCountEdit());
		oneConceptCount.setWaitCountDiscussion(oneConceptCount.getWaitCountDiscussion()+oneMoveAddConcept.getWaitCountDiscussion());

		oneConceptCount.setRefuseCountAll(oneConceptCount.getRefuseCountAll()+oneMoveAddConcept.getRefuseCountAll());
		oneConceptCount.setRefuseCountCreate(oneConceptCount.getRefuseCountCreate()+oneMoveAddConcept.getRefuseCountCreate());
		oneConceptCount.setRefuseCountEdit(oneConceptCount.getRefuseCountEdit()+oneMoveAddConcept.getRefuseCountEdit());
		oneConceptCount.setRefuseCountDiscussion(oneConceptCount.getRefuseCountDiscussion()+oneMoveAddConcept.getRefuseCountDiscussion());
	}


	/**
	 * 减去计数
	 * @param oneConceptCount
	 * @param oneDelConcept
	 */
	private void delConceptCount(Concept oneConceptCount,Concept oneDelConcept){
		
		oneConceptCount.setCenturyCountAll(oneConceptCount.getCenturyCountAll()-oneDelConcept.getCenturyCountAll());
		oneConceptCount.setCenturyCountCreate(oneConceptCount.getCenturyCountCreate()-oneDelConcept.getCenturyCountCreate());
		oneConceptCount.setCenturyCountEdit(oneConceptCount.getCenturyCountEdit()-oneDelConcept.getCenturyCountEdit());
		oneConceptCount.setCenturyCountDiscussion(oneConceptCount.getCenturyCountDiscussion()-oneDelConcept.getCenturyCountDiscussion());
		

		oneConceptCount.setWaitCountAll(oneConceptCount.getWaitCountAll()-oneDelConcept.getWaitCountAll());
		oneConceptCount.setWaitCountCreate(oneConceptCount.getWaitCountCreate()-oneDelConcept.getWaitCountCreate());
		oneConceptCount.setWaitCountEdit(oneConceptCount.getWaitCountEdit()-oneDelConcept.getWaitCountEdit());
		oneConceptCount.setWaitCountDiscussion(oneConceptCount.getWaitCountDiscussion()-oneDelConcept.getWaitCountDiscussion());

		oneConceptCount.setRefuseCountAll(oneConceptCount.getRefuseCountAll()-oneDelConcept.getRefuseCountAll());
		oneConceptCount.setRefuseCountCreate(oneConceptCount.getRefuseCountCreate()-oneDelConcept.getRefuseCountCreate());
		oneConceptCount.setRefuseCountEdit(oneConceptCount.getRefuseCountEdit()-oneDelConcept.getRefuseCountEdit());
		oneConceptCount.setRefuseCountDiscussion(oneConceptCount.getRefuseCountDiscussion()-oneDelConcept.getRefuseCountDiscussion());
	}
	
}
