package xyz.zhiwei.article.morphism.appearance.explorer.viewsingle;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.facet.contribution.ContributionExplorerPage;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.article.morphism.support.facet.PageCondition;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 贡献者分页: 个人视角
 */
public class ContributorViewSingleAppearance implements Appearance{

	//init
    private PageCondition<ContributorSingleInit> init;

    //=============原象=============
    private Source source;
    //贡献值列表
    private List<Contribution> contributionList;
    //关联的探索者列表
    private List<Explorer> explorerList;
	

    //=============构造=============
	//贡献者分页
    private ContributionExplorerPage page;
    

    //初始化
	public ContributorViewSingleAppearance(PageCondition<ContributorSingleInit>  init) {
		this.init=init;
	}

	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

		//核心集定义：概念的贡献列表
    	PrincipleQualifier<Contribution> coreQualifier=Qualify.conceptIdSinglePage(this.init);
		
		return new PrincipleQualifiers(coreQualifier);
	};

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.contributionList=this.source.getContributionList();

		//关联集：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=ExplorerQualify.PQ.contributionList(this.contributionList);
		
		return new PrincipleQualifiers(explorerQualifier);
	};

	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.explorerList=this.source.getExplorerList();
		
		//贡献者分页
		this.page=new ContributionExplorerPage(this.contributionList,this.explorerList);

        return this;
	}


	public ContributionExplorerPage getPage() {
		return page;
	}
    
}
