package xyz.zhiwei.article.morphism.appearance.discussion.viewpage;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.article.qualify.DiscussionQualify;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.article.morphism.support.facet.PageCondition;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * 限定符生成器
 */
class Qualify {

	
	
	/**
	 * 概念的讨论列表
	 * @param condition
	 * @return
	 */
	static PrincipleQualifier<Discussion> page(PageCondition<DiscussionViewPageInit> condition){
		PageCondition<Discussion> discussionCondition=condition.change(DiscussionViewPageInit::getDiscussion);
		
    	return DiscussionQualify.PQ.page(discussionCondition);
	}
	
	/**
	 * 子集限定符：讨论列表里的探索者
	 * @param discussionList
	 * @return
	 */
	static PrincipleQualifier<Explorer> explorerList(List<Discussion> discussionList){
		List<Explorer> idList=discussionList.stream()
				.map(c -> new Explorer(c.getAuthorId()))
				.collect(Collectors.toList());

		return ExplorerQualify.PQ.pkList(idList);
	}
	
	
	
	
}
