package xyz.zhiwei.article.morphism.appearance.discussion.viewpage;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.support.facet.PageCondition;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 讨论分页
 */
public class DiscussionViewPageAppearance implements Appearance{

	//init
    private PageCondition<DiscussionViewPageInit> init;

    //=============原象=============
    private Source source;
    //讨论列表
    private List<Discussion> discussionList;
    //关联的探索者列表
    private List<Explorer> explorerList;
	

    //=============构造=============
	//贡献者分页
    private DiscussionExplorerPage page;
    

    //初始化
	public DiscussionViewPageAppearance(PageCondition<DiscussionViewPageInit>  init) {
		this.init=init;
	}

	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

		//核心集定义：概念的讨论列表
    	PrincipleQualifier<Discussion> coreQualifier=Qualify.page(this.init);
		
		return new PrincipleQualifiers(coreQualifier);
	};

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.discussionList=this.source.getDiscussionList();

		//关联集：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=Qualify.explorerList(this.discussionList);
		
		return new PrincipleQualifiers(explorerQualifier);
	};

	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.explorerList=this.source.getExplorerList();
		
		//贡献者分页
		this.page=new DiscussionExplorerPage(this.discussionList,this.explorerList);

        return this;
	}


	public DiscussionExplorerPage getPage() {
		return page;
	}


    
}
